/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.csv.CSVWriter;
import de.unknownreality.dataframe.csv.CSVWriterBuilder;
import de.unknownreality.dataframe.io.DataWriter;
import de.unknownreality.dataframe.io.FileFormat;
import de.unknownreality.dataframe.io.WriteFormat;
import de.unknownreality.dataframe.meta.DataFrameMeta;
import de.unknownreality.dataframe.meta.DataFrameMetaWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;

public class DataFrameWriter {
    public static final boolean DEFAULT_WRITE_META = true;
    public static final WriteFormat DEFAULT_PRINT_FORMAT = FileFormat.Print;
    public static final WriteFormat DEFAULT_WRITE_FORMAT = FileFormat.TSV;

    public static void write(File file, DataFrame dataFrame, DataWriter dataWriter) {
        DataFrameWriter.write(file, dataFrame, dataWriter, true);
    }

    public static void write(File file, DataFrame dataFrame, DataWriter dataWriter, boolean writeMetaFile) {
        dataWriter.write(file, dataFrame);
        if (writeMetaFile && dataWriter.getReadFormat() != null) {
            DataFrameWriter.writeMetaFile(file, dataFrame, dataWriter);
        }
    }

    public static void write(Writer writer, DataFrame dataFrame, DataWriter dataWriter) {
        dataWriter.write(writer, dataFrame);
    }

    public static void write(OutputStream outputStream, DataFrame dataFrame, DataWriter dataWriter) {
        dataWriter.write(outputStream, dataFrame);
    }

    public static void write(File file, DataFrame dataFrame, WriteFormat writeFormat) {
        DataFrameWriter.write(file, dataFrame, writeFormat, true);
    }

    public static void write(File file, DataFrame dataFrame, WriteFormat writeFormat, boolean writeMetaFile) {
        DataFrameWriter.write(file, dataFrame, writeFormat.getWriterBuilder().build(), writeMetaFile);
    }

    public static void write(Writer writer, DataFrame dataFrame, WriteFormat writeFormat) {
        DataFrameWriter.write(writer, dataFrame, writeFormat.getWriterBuilder().build());
    }

    public static void write(OutputStream outputStream, DataFrame dataFrame, WriteFormat writeFormat) {
        DataFrameWriter.write(outputStream, dataFrame, writeFormat.getWriterBuilder().build());
    }

    public static void write(File file, DataFrame dataFrame) {
        DataFrameWriter.write(file, dataFrame, DEFAULT_WRITE_FORMAT, true);
    }

    public static void write(File file, DataFrame dataFrame, boolean writeMetaFile) {
        DataFrameWriter.write(file, dataFrame, DEFAULT_WRITE_FORMAT, writeMetaFile);
    }

    public static void write(Writer writer, DataFrame dataFrame) {
        DataFrameWriter.write(writer, dataFrame, DEFAULT_WRITE_FORMAT);
    }

    public static void write(OutputStream outputStream, DataFrame dataFrame) {
        DataFrameWriter.write(outputStream, dataFrame, DEFAULT_WRITE_FORMAT);
    }

    public static void writeCSV(File file, DataFrame dataFrame, char separator, boolean writeHeader) {
        DataFrameWriter.writeCSV(file, dataFrame, separator, writeHeader, true);
    }

    public static void writeCSV(File file, DataFrame dataFrame, char separator, boolean writeHeader, boolean writeMetaFile) {
        DataFrameWriter.write(file, dataFrame, CSVWriterBuilder.create().withHeader(writeHeader).withSeparator(separator).build(), writeMetaFile);
    }

    public static void writeCSV(Writer writer, DataFrame dataFrame, char separator, boolean writeHeader) {
        DataFrameWriter.write(writer, dataFrame, (DataWriter)CSVWriterBuilder.create().withHeader(writeHeader).withSeparator(separator).build());
    }

    public static void writeCSV(OutputStream outputStream, DataFrame dataFrame, char separator, boolean writeHeader) {
        DataFrameWriter.write(outputStream, dataFrame, (DataWriter)CSVWriterBuilder.create().withHeader(writeHeader).withSeparator(separator).build());
    }

    public static void writeCSV(File file, DataFrame dataFrame, char separator, String headerPrefix) {
        DataFrameWriter.writeCSV(file, dataFrame, separator, headerPrefix, true);
    }

    public static void writeCSV(File file, DataFrame dataFrame, char separator, String headerPrefix, boolean writeMetaFile) {
        CSVWriter csvWriter = CSVWriterBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build();
        DataFrameWriter.write(file, dataFrame, csvWriter, writeMetaFile);
    }

    public static void writeCSV(Writer writer, DataFrame dataFrame, char separator, String headerPrefix) {
        DataFrameWriter.write(writer, dataFrame, (DataWriter)CSVWriterBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static void writeCSV(OutputStream outputStream, DataFrame dataFrame, char separator, String headerPrefix) {
        DataFrameWriter.write(outputStream, dataFrame, (DataWriter)CSVWriterBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static void writeMetaFile(File file, DataFrame dataFrame, DataWriter dataWriter) {
        File metaFile = new File(file.getAbsolutePath() + "." + "dfm");
        DataFrameMeta meta = DataFrameMeta.create(dataWriter.getReadFormat().getClass(), dataWriter.getMetaColumns(dataFrame), dataWriter.getSettings(dataFrame));
        DataFrameMetaWriter.write(meta, metaFile);
    }

    public static void print(DataFrame dataFrame) {
        DataFrameWriter.write((OutputStream)System.out, dataFrame, DEFAULT_PRINT_FORMAT);
    }

    public static void print(DataFrame dataFrame, DataWriter dataWriter) {
        DataFrameWriter.write((OutputStream)System.out, dataFrame, dataWriter);
    }

    public static void print(DataFrame dataFrame, WriteFormat writeFormat) {
        DataFrameWriter.write((OutputStream)System.out, dataFrame, writeFormat);
    }
}

