/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameConverter;
import de.unknownreality.dataframe.DataFrameException;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.csv.CSVReaderBuilder;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.io.DataIterator;
import de.unknownreality.dataframe.io.DataReader;
import de.unknownreality.dataframe.io.FileFormat;
import de.unknownreality.dataframe.io.ReadFormat;
import de.unknownreality.dataframe.meta.DataFrameMeta;
import de.unknownreality.dataframe.meta.DataFrameMetaReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public class DataFrameLoader {
    private static final ReadFormat DEFAULT_READ_FORMAT = FileFormat.TSV;

    private DataFrameLoader() {
    }

    public static DataFrame fromCSV(File file, char separator, String headerPrefix) {
        return DataFrameLoader.load(file, (DataReader)CSVReaderBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static DataFrame fromCSV(String content, char separator, String headerPrefix) {
        return DataFrameLoader.load(content, (DataReader)CSVReaderBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static DataFrame fromCSV(String resource, ClassLoader classLoader, char separator, String headerPrefix) {
        return DataFrameLoader.load(resource, classLoader, CSVReaderBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static DataFrame fromCSV(URL url, char separator, String headerPrefix) {
        return DataFrameLoader.load(url, (DataReader)CSVReaderBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static DataFrame fromCSV(byte[] bytes, char separator, String headerPrefix) {
        return DataFrameLoader.load(bytes, (DataReader)CSVReaderBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static DataFrame fromCSV(InputStream is, char separator, String headerPrefix) {
        return DataFrameLoader.load(is, (DataReader)CSVReaderBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static DataFrame fromCSV(Reader r, char separator, String headerPrefix) {
        return DataFrameLoader.load(r, (DataReader)CSVReaderBuilder.create().withHeader(true).withSeparator(separator).withHeaderPrefix(headerPrefix).build());
    }

    public static DataFrame fromCSV(File file, char separator, boolean header) {
        return DataFrameLoader.load(file, (DataReader)CSVReaderBuilder.create().withHeader(header).withSeparator(separator).build());
    }

    public static DataFrame fromCSV(String content, char separator, boolean header) {
        return DataFrameLoader.load(content, (DataReader)CSVReaderBuilder.create().withHeader(header).withSeparator(separator).build());
    }

    public static DataFrame fromCSV(String resource, ClassLoader classLoader, char separator, boolean header) {
        return DataFrameLoader.load(resource, classLoader, CSVReaderBuilder.create().withHeader(header).withSeparator(separator).build());
    }

    public static DataFrame fromCSV(URL url, char separator, boolean header) {
        return DataFrameLoader.load(url, (DataReader)CSVReaderBuilder.create().withHeader(header).withSeparator(separator).build());
    }

    public static DataFrame fromCSV(byte[] bytes, char separator, boolean header) {
        return DataFrameLoader.load(bytes, (DataReader)CSVReaderBuilder.create().withHeader(header).withSeparator(separator).build());
    }

    public static DataFrame fromCSV(InputStream is, char separator, boolean header) {
        return DataFrameLoader.load(is, (DataReader)CSVReaderBuilder.create().withHeader(header).withSeparator(separator).build());
    }

    public static DataFrame fromCSV(Reader r, char separator, boolean header) {
        return DataFrameLoader.load(r, (DataReader)CSVReaderBuilder.create().withHeader(header).withSeparator(separator).build());
    }

    public static DataFrame load(String content) {
        return DataFrameLoader.load(content, DEFAULT_READ_FORMAT);
    }

    public static DataFrame load(String resource, ClassLoader classLoader) {
        return DataFrameLoader.load(resource, classLoader, DEFAULT_READ_FORMAT);
    }

    public static DataFrame load(URL url) {
        return DataFrameLoader.load(url, DEFAULT_READ_FORMAT);
    }

    public static DataFrame load(byte[] bytes) {
        return DataFrameLoader.load(bytes, DEFAULT_READ_FORMAT);
    }

    public static DataFrame load(InputStream is) {
        return DataFrameLoader.load(is, DEFAULT_READ_FORMAT);
    }

    public static DataFrame load(Reader reader) {
        return DataFrameLoader.load(reader, DEFAULT_READ_FORMAT);
    }

    public static DataFrame load(File file, ReadFormat readFormat) {
        return DataFrameLoader.load(file, readFormat.getReaderBuilder().build());
    }

    public static DataFrame load(String content, ReadFormat readFormat) {
        return DataFrameLoader.load(content, readFormat.getReaderBuilder().build());
    }

    public static DataFrame load(String resource, ClassLoader classLoader, ReadFormat readFormat) {
        return DataFrameLoader.load(resource, classLoader, readFormat.getReaderBuilder().build());
    }

    public static DataFrame load(URL url, ReadFormat readFormat) {
        return DataFrameLoader.load(url, readFormat.getReaderBuilder().build());
    }

    public static DataFrame load(byte[] bytes, ReadFormat readFormat) {
        return DataFrameLoader.load(bytes, readFormat.getReaderBuilder().build());
    }

    public static DataFrame load(InputStream is, ReadFormat readFormat) {
        return DataFrameLoader.load(is, readFormat.getReaderBuilder().build());
    }

    public static DataFrame load(Reader r, ReadFormat readFormat) {
        return DataFrameLoader.load(r, readFormat.getReaderBuilder().build());
    }

    public static DataFrame load(File file, DataReader reader) {
        return DataFrameLoader.load(reader.load(file));
    }

    public static DataFrame load(String content, DataReader reader) {
        return DataFrameLoader.load(reader.load(content));
    }

    public static DataFrame load(String resource, ClassLoader classLoader, DataReader reader) {
        return DataFrameLoader.load(reader.load(resource, classLoader));
    }

    public static DataFrame load(URL url, DataReader reader) {
        return DataFrameLoader.load(reader.load(url));
    }

    public static DataFrame load(byte[] bytes, DataReader reader) {
        return DataFrameLoader.load(reader.load(bytes));
    }

    public static DataFrame load(InputStream is, DataReader reader) {
        return DataFrameLoader.load(reader.load(is));
    }

    public static DataFrame load(Reader r, DataReader reader) {
        return DataFrameLoader.load(reader.load(r));
    }

    public static DataFrame load(DataIterator<?> dataIterator) {
        return DataFrameConverter.fromDataIterator(dataIterator, FilterPredicate.EMPTY_FILTER);
    }

    public static DataFrame load(DataIterator<?> dataIterator, FilterPredicate predicate) {
        return DataFrameConverter.fromDataIterator(dataIterator, predicate);
    }

    public static DataFrame load(File file, FilterPredicate filterPredicate) {
        File dataFile;
        File metaFile;
        String ext = ".dfm";
        String filePath = file.getAbsolutePath();
        if (file.getName().endsWith(ext)) {
            metaFile = file;
            dataFile = new File(filePath.substring(0, filePath.length() - ext.length()));
        } else {
            dataFile = file;
            metaFile = new File(filePath + ext);
        }
        if (!metaFile.exists()) {
            return DataFrameLoader.load(dataFile, DEFAULT_READ_FORMAT);
        }
        return DataFrameLoader.load(dataFile, metaFile, filterPredicate);
    }

    public static DataFrame load(File file) {
        return DataFrameLoader.load(file, FilterPredicate.EMPTY_FILTER);
    }

    public static DataFrame load(File file, File metaFile, FilterPredicate filterPredicate) {
        DataFrameMeta dataFrameMeta;
        if (!file.exists()) {
            throw new DataFrameRuntimeException(String.format("file not found %s", file.getAbsolutePath()));
        }
        if (!metaFile.exists()) {
            throw new DataFrameRuntimeException(String.format("meta file not found %s", metaFile.getAbsolutePath()));
        }
        try {
            dataFrameMeta = DataFrameMetaReader.read(metaFile);
        }
        catch (DataFrameException e) {
            throw new DataFrameRuntimeException("error loading reading meta file", e);
        }
        DataReader<?, ?> reader = DataFrameLoader.getDataReader(dataFrameMeta);
        Object dataIterator = reader.load(file);
        return DataFrameConverter.fromDataIterator(dataIterator, dataFrameMeta.getSize(), dataFrameMeta.getColumnInformation(), filterPredicate);
    }

    public static DataFrame load(File file, File metaFile) {
        return DataFrameLoader.load(file, metaFile, FilterPredicate.EMPTY_FILTER);
    }

    public static DataFrame loadResource(String path, String metaPath, ClassLoader classLoader, FilterPredicate filterPredicate) {
        DataFrameMeta dataFrameMeta;
        try {
            dataFrameMeta = DataFrameMetaReader.read(classLoader.getResourceAsStream(metaPath));
        }
        catch (DataFrameException e) {
            throw new DataFrameRuntimeException("error reading meta file", e);
        }
        DataReader<?, ?> reader = DataFrameLoader.getDataReader(dataFrameMeta);
        Object dataIterator = reader.load(path, classLoader);
        return DataFrameConverter.fromDataIterator(dataIterator, dataFrameMeta.getColumnInformation(), filterPredicate);
    }

    private static DataReader<?, ?> getDataReader(DataFrameMeta meta) {
        Object reader;
        Object readerBuilder;
        ReadFormat readFormat;
        try {
            readFormat = meta.getReadFormatClass().newInstance();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("error creating readformat instance", e);
        }
        try {
            readerBuilder = readFormat.getReaderBuilder();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("error creating readerBuilder instance", e);
        }
        try {
            reader = readerBuilder.loadSettings(meta.getAttributes()).build();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("error loading readerBuilder attributes", e);
        }
        return reader;
    }

    public static DataFrame loadResource(String path, String metaPath, ClassLoader classLoader) {
        return DataFrameLoader.loadResource(path, metaPath, classLoader, FilterPredicate.EMPTY_FILTER);
    }
}

