/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.ColumnTypeMap;
import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.DefaultDataFrame;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.column.StringColumn;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.parser.Parser;
import de.unknownreality.dataframe.common.parser.ParserUtil;
import de.unknownreality.dataframe.common.row.BasicRow;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.io.ColumnInformation;
import de.unknownreality.dataframe.io.DataIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFrameConverter {
    private static final Logger log = LoggerFactory.getLogger(DataFrameConverter.class);
    public static boolean SAMPLE_ROW_DETECTION = true;
    private static Class<? extends Comparable<?>>[] TYPES = new Class[]{Boolean.class, Integer.class, Long.class, Double.class};
    private static Parser<?>[] TYPE_PARSER = new Parser[]{ParserUtil.findParserOrNull(Boolean.class), ParserUtil.findParserOrNull(Integer.class), ParserUtil.findParserOrNull(Long.class), ParserUtil.findParserOrNull(Double.class)};

    private DataFrameConverter() {
    }

    public static <R extends Row> DataFrame fromDataIterator(DataIterator<R> dataIterator, FilterPredicate filterPredicate) {
        return DataFrameConverter.fromDataIterator(dataIterator, null, filterPredicate);
    }

    public static <R extends Row> DataFrame fromDataIterator(DataIterator<R> dataIterator, List<ColumnInformation> columnsInformation, FilterPredicate filterPredicate) {
        return DataFrameConverter.fromDataIterator(dataIterator, -1, columnsInformation, filterPredicate);
    }

    public static <R extends Row> DataFrame fromDataIterator(DataIterator<R> dataIterator, int expectedSize, List<ColumnInformation> columnsInformation, FilterPredicate filterPredicate) {
        if (columnsInformation == null) {
            columnsInformation = new ArrayList<ColumnInformation>(dataIterator.getColumnsInformation());
        }
        columnsInformation.sort(Comparator.comparingInt(ColumnInformation::getIndex));
        int columnCount = dataIterator.getColumnsInformation().size();
        DefaultDataFrame dataFrame = new DefaultDataFrame();
        DataFrameColumn[] columns = new DataFrameColumn[columnCount];
        boolean[] autodetect = new boolean[columns.length];
        boolean[][] types = new boolean[columns.length][TYPES.length];
        boolean hasAutodetect = false;
        for (int i = 0; i < columnCount; ++i) {
            DataFrameColumn col;
            ColumnInformation columnInformation = columnsInformation.get(i);
            Class<? extends DataFrameColumn> colType = columnInformation.getColumnType();
            try {
                col = colType.newInstance();
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException e) {
                throw new DataFrameRuntimeException(String.format("error creating instance of column [%s], empty constructor required", colType.getCanonicalName()), e);
            }
            if (expectedSize > 128) {
                col.setCapacity(expectedSize);
            }
            col.setName(columnInformation.getName());
            dataFrame.addColumn(col);
            columns[i] = col;
            boolean bl = autodetect[i] = columnInformation.isAutodetect() && columnInformation.getColumnType().equals(StringColumn.class);
            if (!autodetect[i]) continue;
            hasAutodetect = true;
            for (int j = 0; j < TYPES.length; ++j) {
                types[i][j] = true;
            }
        }
        int r = 0;
        for (Row row : dataIterator) {
            Comparable[] rowValues = new Comparable[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                ColumnInformation columnInformation = columnsInformation.get(i);
                Object val = null;
                if (Values.NA.isNA(row.get(columnInformation.getIndex()))) {
                    rowValues[i] = Values.NA;
                    continue;
                }
                try {
                    val = columns[i].getValueFromRow(row, columnInformation.getIndex());
                }
                catch (Exception e) {
                    log.warn("error parsing value ({}), NA added", (Object)e.getMessage());
                }
                if (val == null || Values.NA.isNA(val) || val instanceof String && ("".equals(val.toString()) || "null".equals(val.toString()))) {
                    rowValues[i] = Values.NA;
                    continue;
                }
                if (autodetect[i] && (!SAMPLE_ROW_DETECTION || DataFrameConverter.doSample(r))) {
                    for (int j = 0; j < TYPES.length; ++j) {
                        types[i][j] = types[i][j] && TYPE_PARSER[j].parseOrNull(val.toString()) != null;
                    }
                }
                rowValues[i] = val;
            }
            if (hasAutodetect || filterPredicate.valid(new BasicRow(dataFrame.getHeader(), rowValues, dataFrame.size() - 1))) {
                dataFrame.append(rowValues);
            }
            ++r;
        }
        if (hasAutodetect) {
            DataFrameConverter.replaceAutodetectColumns(dataFrame, autodetect, types);
            if (filterPredicate != null && filterPredicate != FilterPredicate.EMPTY_FILTER) {
                dataFrame.filter(filterPredicate);
            }
        }
        return dataFrame;
    }

    private static boolean doSample(int row) {
        if (row < 100) {
            return true;
        }
        if (row < 1000) {
            return row % 10 == 0;
        }
        if (row < 10000) {
            return row % 100 == 0;
        }
        if (row < 100000) {
            return row % 1000 == 0;
        }
        if (row < 1000000) {
            return row % 10000 == 0;
        }
        if (row < 10000000) {
            return row % 100000 == 0;
        }
        if (row < 100000000) {
            return row % 1000000 == 0;
        }
        return row % 10000000 == 0;
    }

    private static void replaceAutodetectColumns(DataFrame dataFrame, boolean[] autodetect, boolean[][] types) {
        DataFrameColumn[] newColumns = new DataFrameColumn[autodetect.length];
        ArrayList<String> columnNames = new ArrayList<String>(dataFrame.getColumnNames());
        for (int i = 0; i < autodetect.length; ++i) {
            if (!autodetect[i]) continue;
            Class<? extends Comparable<?>> colType = null;
            for (int j = 0; j < TYPES.length; ++j) {
                if (!types[i][j]) continue;
                colType = TYPES[j];
                break;
            }
            if (colType == null) continue;
            DataFrameColumn newColumn = ColumnTypeMap.createColumn(colType);
            newColumn.setName((String)columnNames.get(i));
            newColumn.setCapacity(dataFrame.size());
            newColumns[i] = newColumn;
        }
        for (DataRow row : dataFrame) {
            for (int j = 0; j < autodetect.length; ++j) {
                if (newColumns[j] == null) continue;
                if (row.isNA(j)) {
                    newColumns[j].appendNA();
                    continue;
                }
                String currentVal = row.getString(j);
                Object currentParsedVal = newColumns[j].getParser().parseOrNull(currentVal);
                if (currentParsedVal == null) {
                    newColumns[j] = null;
                    continue;
                }
                newColumns[j].append(currentParsedVal);
            }
        }
        int i = 0;
        ArrayList<DataFrameColumn> columns = new ArrayList<DataFrameColumn>(dataFrame.getColumns());
        for (DataFrameColumn column : columns) {
            if (newColumns[i] != null) {
                dataFrame.replaceColumn(column, newColumns[i]);
            }
            ++i;
        }
    }

    public static <R extends Row> DataFrame fromDataIterator(DataIterator<R> dataIterator) {
        return DataFrameConverter.fromDataIterator(dataIterator, FilterPredicate.EMPTY_FILTER);
    }
}

