/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameConverter;
import de.unknownreality.dataframe.DefaultDataFrame;
import de.unknownreality.dataframe.column.BooleanColumn;
import de.unknownreality.dataframe.column.ByteColumn;
import de.unknownreality.dataframe.column.DoubleColumn;
import de.unknownreality.dataframe.column.FloatColumn;
import de.unknownreality.dataframe.column.IntegerColumn;
import de.unknownreality.dataframe.column.LongColumn;
import de.unknownreality.dataframe.column.ShortColumn;
import de.unknownreality.dataframe.column.StringColumn;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.group.GroupUtil;
import de.unknownreality.dataframe.io.ColumnInformation;
import de.unknownreality.dataframe.io.DataIterator;
import de.unknownreality.dataframe.join.JoinUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class DataFrameBuilder {
    private final LinkedHashMap<String, DataFrameColumn> columns = new LinkedHashMap();
    private JoinUtil joinUtil = null;
    private GroupUtil groupUtil = null;
    private DataIterator<?> dataIterator;
    private FilterPredicate filterPredicate = FilterPredicate.EMPTY_FILTER;
    private String name;

    protected DataFrameBuilder() {
    }

    protected DataFrameBuilder(DataIterator<?> dataIterator) {
        this.dataIterator = dataIterator;
    }

    public static DataFrame createDefault() {
        return new DefaultDataFrame();
    }

    @Deprecated
    public static DataFrameBuilder createFrom(DataIterator<?> dataIterator) {
        return new DataFrameBuilder(dataIterator);
    }

    public static DataFrameBuilder create() {
        return new DataFrameBuilder();
    }

    public DataFrameBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public DataFrameBuilder addColumn(DataFrameColumn column) {
        this.columns.put(column.getName(), column);
        return this;
    }

    public DataFrameBuilder addBooleanColumn(String name) {
        BooleanColumn column = new BooleanColumn(name);
        return this.addColumn(column);
    }

    public DataFrameBuilder addByteColumn(String name) {
        ByteColumn column = new ByteColumn(name);
        return this.addColumn(column);
    }

    public DataFrameBuilder addDoubleColumn(String name) {
        DoubleColumn column = new DoubleColumn(name);
        return this.addColumn(column);
    }

    public DataFrameBuilder addFloatColumn(String name) {
        FloatColumn column = new FloatColumn(name);
        return this.addColumn(column);
    }

    public DataFrameBuilder addIntegerColumn(String name) {
        IntegerColumn column = new IntegerColumn(name);
        return this.addColumn(column);
    }

    public DataFrameBuilder addLongColumn(String name) {
        LongColumn column = new LongColumn(name);
        return this.addColumn(column);
    }

    public DataFrameBuilder addShortColumn(String name) {
        ShortColumn column = new ShortColumn(name);
        return this.addColumn(column);
    }

    public DataFrameBuilder addStringColumn(String name) {
        StringColumn column = new StringColumn(name);
        return this.addColumn(column);
    }

    public DataFrameBuilder setGroupUtil(GroupUtil groupUtil) {
        this.groupUtil = groupUtil;
        return this;
    }

    public DataFrameBuilder setJoinUtil(JoinUtil joinUtil) {
        this.joinUtil = joinUtil;
        return this;
    }

    public DataFrameBuilder withFilterPredicate(String predicate) {
        this.filterPredicate = FilterPredicate.compile(predicate);
        return this;
    }

    public DataFrameBuilder withFilterPredicate(FilterPredicate predicate) {
        this.filterPredicate = predicate;
        return this;
    }

    public DataFrameBuilder from(DataIterator<?> dataIterator) {
        this.dataIterator = dataIterator;
        return this;
    }

    public DataFrameBuilder addColumn(String header, DataFrameColumn column) {
        this.columns.put(header, column);
        return this;
    }

    public LinkedHashMap<String, DataFrameColumn> getColumns() {
        return this.columns;
    }

    public DataFrame build() {
        if (this.dataIterator != null) {
            List<ColumnInformation> columnInformationList = new ArrayList<ColumnInformation>();
            int i = 0;
            for (String n : this.columns.keySet()) {
                ColumnInformation columnInformation = new ColumnInformation(i, n);
                columnInformation.setColumnType(this.columns.get(n).getClass());
                columnInformationList.add(columnInformation);
                ++i;
            }
            if (columnInformationList.isEmpty()) {
                columnInformationList = this.dataIterator.getColumnsInformation();
            }
            return DataFrameConverter.fromDataIterator(this.dataIterator, columnInformationList, this.filterPredicate);
        }
        DefaultDataFrame dataFrame = new DefaultDataFrame(this.name);
        for (String n : this.columns.keySet()) {
            DataFrameColumn col = this.columns.get(n);
            col.setName(n);
            dataFrame.addColumn(col);
        }
        if (this.joinUtil != null) {
            dataFrame.setJoinUtil(this.joinUtil);
        }
        if (this.groupUtil != null) {
            dataFrame.setGroupUtil(this.groupUtil);
        }
        return dataFrame;
    }
}

