/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.column.BooleanColumn;
import de.unknownreality.dataframe.column.ByteColumn;
import de.unknownreality.dataframe.column.DoubleColumn;
import de.unknownreality.dataframe.column.FloatColumn;
import de.unknownreality.dataframe.column.IntegerColumn;
import de.unknownreality.dataframe.column.LongColumn;
import de.unknownreality.dataframe.column.ShortColumn;
import de.unknownreality.dataframe.column.StringColumn;
import java.util.HashMap;
import java.util.Map;

public class ColumnTypeMap {
    private static final Map<Class<?>, Class<? extends DataFrameColumn>> DEFAULT_COLUMN_TYPES = new HashMap();
    private static final Map<Class<?>, Class<? extends DataFrameColumn>> ADDITIONAL_COLUMN_TYPES = new HashMap();
    private static final ColumnTypeMap defaultInstance;
    private final Map<Class<?>, Class<? extends DataFrameColumn>> columnTypesMap = new HashMap();

    public static synchronized <T extends Comparable<T>> void registerType(Class<T> cl, Class<? extends DataFrameColumn<T, ?>> colType) {
        ADDITIONAL_COLUMN_TYPES.put(cl, colType);
    }

    public static <T extends Comparable<T>, C extends DataFrameColumn<T, ?>> Class<C> get(Class<T> type) {
        return defaultInstance.getColumnType(type);
    }

    public static <T extends Comparable<T>, C extends DataFrameColumn<T, ?>> DataFrameColumn createColumn(Class<T> type) {
        return defaultInstance.getColumn(type);
    }

    private ColumnTypeMap() {
        this.columnTypesMap.putAll(DEFAULT_COLUMN_TYPES);
        this.columnTypesMap.putAll(ADDITIONAL_COLUMN_TYPES);
    }

    public <T extends Comparable<T>, C extends DataFrameColumn<T, ?>> Class<C> getColumnType(Class<T> type) {
        Class<? extends DataFrameColumn> columnType = this.columnTypesMap.get(type);
        if (columnType == null) {
            throw new DataFrameRuntimeException(String.format("no column type found for value type '%s'", type.getCanonicalName()));
        }
        return columnType;
    }

    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> ColumnTypeMap addType(Class<T> type, Class<C> columnType) {
        this.columnTypesMap.put(type, columnType);
        return this;
    }

    public <T extends Comparable<T>, C extends DataFrameColumn<T, ?>> C getColumn(Class<T> type) {
        Class<C> columnType = this.getColumnType(type);
        DataFrameColumn newColumn = null;
        try {
            newColumn = (DataFrameColumn)columnType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DataFrameRuntimeException(String.format("error creating column instance (%s)", columnType.getCanonicalName()));
        }
        return (C)newColumn;
    }

    public static ColumnTypeMap create() {
        return new ColumnTypeMap();
    }

    static {
        DEFAULT_COLUMN_TYPES.put(String.class, StringColumn.class);
        DEFAULT_COLUMN_TYPES.put(Double.class, DoubleColumn.class);
        DEFAULT_COLUMN_TYPES.put(Integer.class, IntegerColumn.class);
        DEFAULT_COLUMN_TYPES.put(Float.class, FloatColumn.class);
        DEFAULT_COLUMN_TYPES.put(Long.class, LongColumn.class);
        DEFAULT_COLUMN_TYPES.put(Boolean.class, BooleanColumn.class);
        DEFAULT_COLUMN_TYPES.put(Short.class, ShortColumn.class);
        DEFAULT_COLUMN_TYPES.put(Byte.class, ByteColumn.class);
        defaultInstance = ColumnTypeMap.create();
    }
}

