/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;

public class SwingUtilities {
    public static void runOnEventDispatchThread(Runnable runnable) throws InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static Window getAncestorWindow(Component component) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        return (Window)container;
    }

    protected SwingUtilities() {
    }
}

