/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class EnhancedDocument
extends PlainDocument {
    public static final String PROPERTY_EDITABLE = "editable";
    private static final long serialVersionUID = 1L;
    private boolean editable = true;
    protected PropertyChangeSupport changeSupport;

    public EnhancedDocument() {
    }

    public EnhancedDocument(AbstractDocument.Content content) {
        super(content);
    }

    public EnhancedDocument(String string) {
        EnhancedDocument.setText(this, string);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.isEditable();
        if (bl2 == bl) {
            return;
        }
        this.editable = bl;
        this.firePropertyChange(PROPERTY_EDITABLE, bl2, bl);
    }

    public String getText() {
        return EnhancedDocument.getText(this);
    }

    public void setText(String string) {
        EnhancedDocument.setText(this, string);
    }

    static String getText(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError((Object)badLocationException);
        }
    }

    static void setText(Document document, String string) {
        try {
            int n = document.getLength();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).replace(0, n, string, null);
            } else {
                document.remove(0, n);
                document.insertString(0, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError((Object)badLocationException);
        }
    }

    public String toString() {
        return this.getText();
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (null != this.changeSupport) {
            this.changeSupport.firePropertyChange(string, (Object)bl, (Object)bl2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null == this.changeSupport) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (null != this.changeSupport) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (null == this.changeSupport) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (null != this.changeSupport) {
            this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }
}

