/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.EnhancedComboBoxModel;
import de.schlichtherle.swing.EnhancedDocument;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.Document;

public class ComboBoxDocumentMediator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Listener listener = new Listener();
    private Document document;
    private ComboBoxModel comboBoxModel;
    private transient boolean recursion;

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document == document2) {
            return;
        }
        if (null != document2) {
            document2.removeDocumentListener(this.listener);
            if (document2 instanceof EnhancedDocument) {
                ((EnhancedDocument)document2).removePropertyChangeListener("editable", this.listener);
            }
        }
        this.document = document;
        if (null != document) {
            document.addDocumentListener(this.listener);
            this.documentUpdated();
            if (document instanceof EnhancedDocument) {
                ((EnhancedDocument)document).addPropertyChangeListener("editable", this.listener);
                this.documentEditableChanged();
            }
        }
    }

    public ComboBoxModel getComboBoxModel() {
        return this.comboBoxModel;
    }

    public void setComboBoxModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this.getComboBoxModel();
        if (comboBoxModel == comboBoxModel2) {
            return;
        }
        if (null != comboBoxModel2) {
            comboBoxModel2.removeListDataListener(this.listener);
            if (comboBoxModel2 instanceof EnhancedComboBoxModel) {
                ((EnhancedComboBoxModel)comboBoxModel2).removePropertyChangeListener("enabled", this.listener);
            }
        }
        this.comboBoxModel = comboBoxModel;
        if (null != comboBoxModel) {
            comboBoxModel.addListDataListener(this.listener);
            this.comboBoxModelSelectionChanged();
            if (comboBoxModel instanceof EnhancedComboBoxModel) {
                ((EnhancedComboBoxModel)comboBoxModel).addPropertyChangeListener("enabled", this.listener);
                this.comboBoxModelEnabledChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentUpdated() {
        if (this.lock()) {
            return;
        }
        try {
            ComboBoxModel comboBoxModel = this.getComboBoxModel();
            if (comboBoxModel == null) {
                return;
            }
            Document document = this.getDocument();
            String string = ComboBoxDocumentMediator.getText(document);
            comboBoxModel.setSelectedItem(string);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentEditableChanged() {
        if (this.lock()) {
            return;
        }
        try {
            ComboBoxModel comboBoxModel = this.getComboBoxModel();
            if (comboBoxModel instanceof EnhancedComboBoxModel) {
                EnhancedComboBoxModel enhancedComboBoxModel = (EnhancedComboBoxModel)comboBoxModel;
                boolean bl = ((EnhancedDocument)this.getDocument()).isEditable();
                enhancedComboBoxModel.setEditable(bl);
                enhancedComboBoxModel.setEnabled(bl);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboBoxModelSelectionChanged() {
        if (this.lock()) {
            return;
        }
        try {
            Document document = this.getDocument();
            if (document == null) {
                return;
            }
            ComboBoxModel comboBoxModel = this.getComboBoxModel();
            Object object = comboBoxModel.getSelectedItem();
            ComboBoxDocumentMediator.setText(document, object != null ? object.toString() : null);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboBoxModelEnabledChanged() {
        if (this.lock()) {
            return;
        }
        try {
            Document document = this.getDocument();
            if (document instanceof EnhancedDocument) {
                ((EnhancedDocument)document).setEditable(((EnhancedComboBoxModel)this.getComboBoxModel()).isEnabled());
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean lock() {
        if (this.recursion) {
            return true;
        }
        this.recursion = true;
        return false;
    }

    private void unlock() {
        this.recursion = false;
    }

    public static String getText(Document document) {
        return EnhancedDocument.getText(document);
    }

    public static void setText(Document document, String string) {
        EnhancedDocument.setText(document, string);
    }

    private final class Listener
    implements DocumentListener,
    ListDataListener,
    PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Listener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ComboBoxDocumentMediator.this.documentUpdated();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ComboBoxDocumentMediator.this.documentUpdated();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            ComboBoxDocumentMediator.this.documentUpdated();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (listDataEvent.getIndex0() < 0 && listDataEvent.getIndex1() < 0) {
                ComboBoxDocumentMediator.this.comboBoxModelSelectionChanged();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                ComboBoxDocumentMediator.this.comboBoxModelEnabledChanged();
            } else if ("editable".equals(string)) {
                ComboBoxDocumentMediator.this.documentEditableChanged();
            } else {
                throw new AssertionError((Object)("Received change event for unknown property: " + string));
            }
        }
    }
}

