/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license.wizard;

import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.wizard.Dialogs;
import de.schlichtherle.license.wizard.Resources;
import de.schlichtherle.swing.Defaults;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicensePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final LicenseManager manager;
    private LicenseContent content;
    private JTextArea consumerComponent;
    private JLabel consumerLabel;
    private JTextArea holderComponent;
    private JLabel holderLabel;
    private JScrollPane holderScrollPane;
    private JTextArea infoComponent;
    private JLabel infoLabel;
    private JScrollPane infoScrollPane;
    private JTextArea issuedComponent;
    private JLabel issuedLabel;
    private JTextArea issuerComponent;
    private JLabel issuerLabel;
    private JScrollPane issuerScrollPane;
    private JTextArea notAfterComponent;
    private JLabel notAfterLabel;
    private JTextArea notBeforeComponent;
    private JLabel notBeforeLabel;
    private JTextArea subjectComponent;
    private JLabel subjectLabel;

    public LicensePanel(LicenseManager licenseManager) {
        this.manager = licenseManager;
        this.initComponents();
    }

    public final void verify() throws Exception {
        this.content = this.manager.verify();
        this.updatePanel();
    }

    protected void updatePanel() {
        if (null == this.content) {
            return;
        }
        this.subjectComponent.setText(this.toString(this.content.getSubject()));
        this.holderComponent.setText(this.toString(this.content.getHolder()));
        this.infoComponent.setText(this.toString(this.content.getInfo()));
        this.consumerComponent.setText(this.toString(this.content.getConsumerType()) + " (" + this.content.getConsumerAmount() + ")");
        this.notBeforeComponent.setText(this.format(this.content.getNotBefore()));
        this.notAfterComponent.setText(this.format(this.content.getNotAfter()));
        this.issuerComponent.setText(this.toString(this.content.getIssuer()));
        this.issuedComponent.setText(this.format(this.content.getIssued()));
    }

    private String format(Date date) {
        return null != date ? DateFormat.getDateTimeInstance(1, 1).format(date) : "";
    }

    private String toString(Object object) {
        return null != object ? object.toString() : "";
    }

    private void initComponents() {
        this.holderLabel = new JLabel();
        this.holderScrollPane = new JScrollPane();
        this.holderComponent = new JTextArea();
        this.subjectLabel = new JLabel();
        this.subjectComponent = new JTextArea();
        this.consumerLabel = new JLabel();
        this.consumerComponent = new JTextArea();
        this.notBeforeLabel = new JLabel();
        this.notBeforeComponent = new JTextArea();
        this.notAfterLabel = new JLabel();
        this.notAfterComponent = new JTextArea();
        this.issuerLabel = new JLabel();
        this.issuerScrollPane = new JScrollPane();
        this.issuerComponent = new JTextArea();
        this.issuedLabel = new JLabel();
        this.issuedComponent = new JTextArea();
        this.infoLabel = new JLabel();
        this.infoScrollPane = new JScrollPane();
        this.infoComponent = new JTextArea();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, Resources.getString("LicensePanel.title"), 0, 0, Defaults.labelBoldFont), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.setLayout(new GridBagLayout());
        this.holderLabel.setLabelFor(this.holderComponent);
        this.holderLabel.setText(Resources.getString("LicensePanel.holder.label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.holderLabel, gridBagConstraints);
        this.holderScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.holderScrollPane.setHorizontalScrollBarPolicy(31);
        this.holderScrollPane.setPreferredSize(new Dimension(300, 65));
        this.holderComponent.setEditable(false);
        this.holderComponent.setLineWrap(true);
        this.holderComponent.setWrapStyleWord(true);
        this.holderComponent.setBorder(null);
        this.holderComponent.setName("holder");
        this.holderScrollPane.setViewportView(this.holderComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.holderScrollPane, gridBagConstraints);
        this.subjectLabel.setLabelFor(this.subjectComponent);
        this.subjectLabel.setText(Resources.getString("LicensePanel.subject.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.subjectLabel, gridBagConstraints);
        this.subjectComponent.setEditable(false);
        this.subjectComponent.setBorder(BorderFactory.createEtchedBorder());
        this.subjectComponent.setName("subject");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.subjectComponent, gridBagConstraints);
        this.consumerLabel.setLabelFor(this.consumerComponent);
        this.consumerLabel.setText(Resources.getString("LicensePanel.consumer.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.consumerLabel, gridBagConstraints);
        this.consumerComponent.setEditable(false);
        this.consumerComponent.setBorder(BorderFactory.createEtchedBorder());
        this.consumerComponent.setName("consumer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.consumerComponent, gridBagConstraints);
        this.notBeforeLabel.setLabelFor(this.notBeforeComponent);
        this.notBeforeLabel.setText(Resources.getString("LicensePanel.notBefore.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.notBeforeLabel, gridBagConstraints);
        this.notBeforeComponent.setEditable(false);
        this.notBeforeComponent.setBorder(BorderFactory.createEtchedBorder());
        this.notBeforeComponent.setName("notBefore");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.notBeforeComponent, gridBagConstraints);
        this.notAfterLabel.setLabelFor(this.notAfterComponent);
        this.notAfterLabel.setText(Resources.getString("LicensePanel.notAfter.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.notAfterLabel, gridBagConstraints);
        this.notAfterComponent.setEditable(false);
        this.notAfterComponent.setBorder(BorderFactory.createEtchedBorder());
        this.notAfterComponent.setName("notAfter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.notAfterComponent, gridBagConstraints);
        this.issuerLabel.setLabelFor(this.issuerComponent);
        this.issuerLabel.setText(Resources.getString("LicensePanel.issuer.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.issuerLabel, gridBagConstraints);
        this.issuerScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.issuerScrollPane.setHorizontalScrollBarPolicy(31);
        this.issuerScrollPane.setPreferredSize(new Dimension(300, 65));
        this.issuerComponent.setEditable(false);
        this.issuerComponent.setLineWrap(true);
        this.issuerComponent.setWrapStyleWord(true);
        this.issuerComponent.setBorder(null);
        this.issuerComponent.setName("issuer");
        this.issuerScrollPane.setViewportView(this.issuerComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.issuerScrollPane, gridBagConstraints);
        this.issuedLabel.setLabelFor(this.issuedComponent);
        this.issuedLabel.setText(Resources.getString("LicensePanel.issued.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.issuedLabel, gridBagConstraints);
        this.issuedComponent.setEditable(false);
        this.issuedComponent.setBorder(BorderFactory.createEtchedBorder());
        this.issuedComponent.setName("issued");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.issuedComponent, gridBagConstraints);
        this.infoLabel.setLabelFor(this.infoComponent);
        this.infoLabel.setText(Resources.getString("LicensePanel.info.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.infoLabel, gridBagConstraints);
        this.infoScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.infoScrollPane.setHorizontalScrollBarPolicy(31);
        this.infoScrollPane.setPreferredSize(new Dimension(300, 65));
        this.infoComponent.setEditable(false);
        this.infoComponent.setLineWrap(true);
        this.infoComponent.setWrapStyleWord(true);
        this.infoComponent.setBorder(null);
        this.infoComponent.setName("info");
        this.infoScrollPane.setViewportView(this.infoComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.infoScrollPane, gridBagConstraints);
    }

    public static class Descriptor
    extends WizardPanelDescriptor {
        public static final String IDENTIFIER = "LICENSE_PANEL";

        public Descriptor(LicenseManager licenseManager) {
            super(IDENTIFIER, new LicensePanel(licenseManager));
        }

        public Object getNextPanelDescriptor() {
            return FINISH;
        }

        public Object getBackPanelDescriptor() {
            return "WELCOME_PANEL";
        }

        public void aboutToDisplayPanel() {
            LicensePanel licensePanel = (LicensePanel)this.getPanelComponent();
            try {
                licensePanel.verify();
            }
            catch (Exception exception) {
                Dialogs.showMessageDialog(licensePanel, exception.getLocalizedMessage(), Resources.getString("LicensePanel.failure.title"), 0);
            }
        }
    }
}

