/*
 * Decompiled with CFR 0.152.
 */
package com.nexes.wizard;

import com.nexes.wizard.Wizard;
import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WizardController
implements ActionListener {
    private final Wizard wizard;

    public WizardController(Wizard wizard) {
        this.wizard = wizard;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("BackButtonActionCommand")) {
            this.backButtonPressed();
        } else if (string.equals("NextButtonActionCommand")) {
            this.nextButtonPressed();
        } else if (string.equals("CancelButtonActionCommand")) {
            this.cancelButtonPressed();
        }
    }

    private void backButtonPressed() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        Object object = wizardPanelDescriptor.getBackPanelDescriptor();
        this.wizard.setCurrentPanel(object);
    }

    private void nextButtonPressed() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        Object object = wizardPanelDescriptor.getNextPanelDescriptor();
        if (object instanceof WizardPanelDescriptor.FinishIdentifier) {
            this.wizard.close(0);
        } else {
            this.wizard.setCurrentPanel(object);
        }
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    void resetButtonsToPanelRules() {
        WizardModel wizardModel = this.wizard.getModel();
        WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanelDescriptor();
        wizardModel.setBackButtonText(Wizard.DEFAULT_BACK_BUTTON_TEXT);
        if (wizardPanelDescriptor.getBackPanelDescriptor() != null) {
            wizardModel.setBackButtonEnabled(Boolean.TRUE);
        } else {
            wizardModel.setBackButtonEnabled(Boolean.FALSE);
        }
        if (wizardPanelDescriptor.getNextPanelDescriptor() != null) {
            wizardModel.setNextButtonEnabled(Boolean.TRUE);
        } else {
            wizardModel.setNextButtonEnabled(Boolean.FALSE);
        }
        if (wizardPanelDescriptor.getNextPanelDescriptor() instanceof WizardPanelDescriptor.FinishIdentifier) {
            wizardModel.setNextButtonText(Wizard.DEFAULT_FINISH_BUTTON_TEXT);
            wizardModel.setNextButtonEnabled(Boolean.TRUE);
        } else {
            wizardModel.setNextButtonText(Wizard.DEFAULT_NEXT_BUTTON_TEXT);
        }
    }
}

