/*
 * Copyright (C) 2005-2015 Schlichtherle IT Services.
 * All rights reserved. Use is subject to license terms.
 */
package de.schlichtherle.license.wizard;

import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.swing.Defaults;
import de.schlichtherle.swing.SwingUtilities;

/**
 * @author Christian Schlichtherle
 */
public class WelcomePanel extends javax.swing.JPanel {

    private static final long serialVersionUID = 1L;
    private final LicenseManager manager;

    public WelcomePanel(LicenseManager manager) {
        this.manager = manager;
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        welcome = new javax.swing.JTextArea();
        installButton = new de.schlichtherle.swing.EnhancedRadioButton();
        verifyButton = new de.schlichtherle.swing.EnhancedRadioButton();

        setLayout(new java.awt.GridBagLayout());

        welcome.setEditable(false);
        welcome.setFont(Defaults.labelBoldFont);
        welcome.setLineWrap(true);
        welcome.setText(Resources.getString("WelcomePanel.welcome.text", new Object[] {manager.getLicenseParam().getSubject()})); // NOI18N
        welcome.setWrapStyleWord(true);
        welcome.setBorder(null);
        welcome.setOpaque(false);
        welcome.setPreferredSize(new java.awt.Dimension(370, 90));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 15, 0);
        add(welcome, gridBagConstraints);

        buttonGroup.add(installButton);
        installButton.setSelected(true);
        installButton.setText(Resources.getString("WelcomePanel.installButton.text")); // NOI18N
        installButton.setActionCommand(InstallPanel.Descriptor.IDENTIFIER);
        installButton.setName("install");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 2, 0);
        add(installButton, gridBagConstraints);

        buttonGroup.add(verifyButton);
        verifyButton.setText(Resources.getString("WelcomePanel.verifyButton.text")); // NOI18N
        verifyButton.setActionCommand(LicensePanel.Descriptor.IDENTIFIER);
        verifyButton.setName("verify");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 0);
        add(verifyButton, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private final javax.swing.ButtonGroup buttonGroup = new javax.swing.ButtonGroup();
    private de.schlichtherle.swing.EnhancedRadioButton installButton;
    private de.schlichtherle.swing.EnhancedRadioButton verifyButton;
    private javax.swing.JTextArea welcome;
    // End of variables declaration//GEN-END:variables

    /**
     * Starts a separate thread to verify the license certificate. This is
     * provided for faster startup of the welcome panel.
     */
    private void startVerifyingLicense(final WizardModel wizardModel) {
        wizardModel.setNextButtonEnabled(Boolean.FALSE);
        verifyButton.setEnabled(false);
        final Thread thread = new Thread() {
            public void run() {
                try {
                    // Check license certificate
                    manager.verify();
                    SwingUtilities.runOnEventDispatchThread(new Runnable() {
                        public void run() {
                            verifyButton.setEnabled(true);
                            buttonGroup.setSelected(verifyButton.getModel(), true);
                            wizardModel.setNextButtonEnabled(Boolean.TRUE);
                        }
                    });
                } catch (final Exception ex) {
                    try {
                        SwingUtilities.runOnEventDispatchThread(new Runnable() {
                            public void run() {
                                verifyButton.setEnabled(false);
                                buttonGroup.setSelected(installButton.getModel(), true);
                                wizardModel.setNextButtonEnabled(Boolean.TRUE);
                            }
                        });
                    } catch (Exception cannotHappen) {
                        throw new AssertionError(cannotHappen);
                    }
                }
            }
        };
        thread.setPriority(Thread.MIN_PRIORITY);
        thread.start();
    }

    public static class Descriptor extends WizardPanelDescriptor {
        public static final String IDENTIFIER = "WELCOME_PANEL"; // NOI18N

        public Descriptor(LicenseManager manager) {
            super(IDENTIFIER, new WelcomePanel(manager));
        }

        public Object getNextPanelDescriptor() {
            return ((WelcomePanel) getPanelComponent()).buttonGroup.getSelection().getActionCommand();
        }

        public Object getBackPanelDescriptor() {
            return null;
        }

        public void aboutToDisplayPanel() {
            WelcomePanel panel = (WelcomePanel) getPanelComponent();
            panel.startVerifyingLicense(getWizardModel());
        }
    }
}
