/*
 * Copyright (C) 2005-2015 Schlichtherle IT Services.
 * All rights reserved. Use is subject to license terms.
 */
package de.schlichtherle.license.wizard;

import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.swing.Defaults;
import java.awt.Cursor;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

/**
 * @author Christian Schlichtherle
 */
public class InstallPanel extends javax.swing.JPanel {

    private static final long serialVersionUID = 1L;
    private final LicenseManager manager;

    public InstallPanel(LicenseManager manager) {
        this.manager = manager;
        initComponents();
        fileField.getDocument().addDocumentListener(
                new DocumentListener() {
                    public void insertUpdate(DocumentEvent e) {
                        updateFileField();
                    }

                    public void removeUpdate(DocumentEvent e) {
                        updateFileField();
                    }

                    public void changedUpdate(DocumentEvent e) {
                        updateFileField();
                    }
                });
    }

    private void updateFileField() {
        final String fileName = fileField.getText();
        installButton.setEnabled(null != fileName && new File(fileName).isFile());
    }

    public void setVisible(boolean visible) {
        if (visible) updateFileField();
        super.setVisible(visible);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        filechooser = new javax.swing.JFileChooser();
        prompt = new javax.swing.JTextArea();
        fileButton = new javax.swing.JButton();
        installButton = new de.schlichtherle.swing.EnhancedButton();
        success = new javax.swing.JTextArea();

        filechooser.setFileFilter(manager.getFileFilter());

        setLayout(new java.awt.GridBagLayout());

        prompt.setEditable(false);
        prompt.setFont(Defaults.labelBoldFont);
        prompt.setLineWrap(true);
        prompt.setText(Resources.getString("InstallPanel.prompt.text", new Object[] {manager.getLicenseParam().getSubject() // NOI18N
        }));
        prompt.setWrapStyleWord(true);
        prompt.setBorder(null);
        prompt.setOpaque(false);
        prompt.setPreferredSize(new java.awt.Dimension(370, 30));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 15, 0);
        add(prompt, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 0);
        add(fileField, gridBagConstraints);

        fileButton.setText("...");
        fileButton.setName("select");
        fileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 0);
        add(fileButton, gridBagConstraints);

        installButton.setText(Resources.getString("InstallPanel.installButton.text")); // NOI18N
        installButton.setName("install");
        installButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                installButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 0, 0);
        add(installButton, gridBagConstraints);

        success.setEditable(false);
        success.setFont(Defaults.labelBoldFont);
        success.setBorder(null);
        success.setOpaque(false);
        success.setPreferredSize(new java.awt.Dimension(350, 60));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 0, 0);
        add(success, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void installButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_installButtonActionPerformed
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        try {
            LicenseContent content = manager.install(new File(fileField.getText()));
            installButton.setEnabled(false);
            success.setText(Resources.getString("InstallPanel.success.text"));
            fireLicenseInstalled(content);
        } catch (final Exception ex) {
            Dialogs.showMessageDialog(
                    this,
                    ex.getLocalizedMessage(),
                    Resources.getString("InstallPanel.failure.title"),
                    Dialogs.ERROR_MESSAGE);
        } finally {
            setCursor(null);
        }
    }//GEN-LAST:event_installButtonActionPerformed

    private void fileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileButtonActionPerformed
        if (filechooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
            fileField.setText(filechooser.getSelectedFile().getPath());
    }//GEN-LAST:event_fileButtonActionPerformed

    /**
     * Registers LicenseInstalledListener to receive events.
     *
     * @param listener The listener to register.
     */
    public void addLicenseInstalledListener(LicenseInstalledListener listener) {
        if (null == listenerList)
            listenerList = new EventListenerList();
        listenerList.add(LicenseInstalledListener.class, listener);
    }

    /**
     * Removes LicenseInstalledListener from the list of listeners.
     *
     * @param listener The listener to remove.
     */
    public void removeLicenseInstalledListener(LicenseInstalledListener listener) {
        if (null != listenerList)
            listenerList.remove(LicenseInstalledListener.class, listener);
    }

    /**
     * Notifies all registered listeners about the event.
     *
     * @param content The license content that has been successfully installed.
     */
    protected void fireLicenseInstalled(LicenseContent content) {
        if (null == listenerList)
            return;
        Object[] listeners = listenerList.getListenerList();
        LicenseInstalledEvent e = null;
        for (int i = listeners.length - 2; 0 <= i; i -= 2) {
            if (listeners[i] == LicenseInstalledListener.class) {
                if (null == e)
                    e = new LicenseInstalledEvent(this, content);
                ((LicenseInstalledListener) listeners[i + 1]).licenseInstalled(e);
            }
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton fileButton;
    private final javax.swing.JTextField fileField = new javax.swing.JTextField();
    private javax.swing.JFileChooser filechooser;
    private de.schlichtherle.swing.EnhancedButton installButton;
    private javax.swing.JTextArea prompt;
    private javax.swing.JTextArea success;
    // End of variables declaration//GEN-END:variables

    public static class Descriptor extends WizardPanelDescriptor {
        public static final String IDENTIFIER = "INSTALL_PANEL"; // NOI18N

        public Descriptor(LicenseManager manager) {
            setPanelDescriptorIdentifier(IDENTIFIER);
            final InstallPanel panel = new InstallPanel(manager);
            setPanelComponent(panel);
            panel.addLicenseInstalledListener(new LicenseInstalledListener() {
                public void licenseInstalled(LicenseInstalledEvent evt) {
                    getWizardModel().setNextButtonEnabled(Boolean.TRUE);
                }
            });
        }

        public Object getNextPanelDescriptor() {
            return LicensePanel.Descriptor.IDENTIFIER;
        }

        public Object getBackPanelDescriptor() {
            return WelcomePanel.Descriptor.IDENTIFIER;
        }

        public void aboutToDisplayPanel() {
            final InstallPanel panel = (InstallPanel) getPanelComponent();
            //panel.updateFileField();
            panel.success.setText(null);
            getWizardModel().setNextButtonEnabled(Boolean.FALSE);
        }
    }
}
