/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.singlebyte;

import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import java.util.Random;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ByteXorModification
extends VariableModification<Byte> {
    private static final int MAX_XOR_MODIFIER = 16;
    private Byte xor;

    public ByteXorModification() {
    }

    public ByteXorModification(Byte bi) {
        this.xor = bi;
    }

    @Override
    protected Byte modifyImplementationHook(Byte input) {
        if (input == null) {
            input = 0;
        }
        return (byte)(input ^ this.xor);
    }

    public Byte getXor() {
        return this.xor;
    }

    public void setXor(Byte xor) {
        this.xor = xor;
    }

    @Override
    public VariableModification<Byte> getModifiedCopy() {
        Random r = new Random();
        if (r.nextBoolean()) {
            return new ByteXorModification((byte)(this.xor + r.nextInt(16)));
        }
        return new ByteXorModification((byte)(this.xor - r.nextInt(16)));
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.xor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteXorModification other = (ByteXorModification)obj;
        return Objects.equals(this.xor, other.xor);
    }
}

