/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.mlong;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.mlong.LongModificationFactory;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ModifiableLong
extends ModifiableVariable<Long>
implements Serializable {
    private Long originalValue;

    @Override
    protected void createRandomModification() {
        VariableModification<Long> vm = LongModificationFactory.createRandomModification();
        this.setModification(vm);
    }

    public Long getAssertEquals() {
        return (Long)this.assertEquals;
    }

    public void setAssertEquals(Long assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        return this.originalValue != null && this.originalValue.compareTo((Long)this.getValue()) != 0;
    }

    public byte[] getByteArray(int size) {
        return ArrayConverter.longToBytes((Long)this.getValue(), size);
    }

    @Override
    public boolean validateAssertions() {
        boolean valid = true;
        if (this.assertEquals != null && ((Long)this.assertEquals).compareTo((Long)this.getValue()) != 0) {
            valid = false;
        }
        return valid;
    }

    @Override
    public Long getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(Long originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableLong{originalValue=" + this.originalValue + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifiableLong)) {
            return false;
        }
        ModifiableLong that = (ModifiableLong)o;
        return this.getValue() != null ? ((Long)this.getValue()).equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((Long)this.getValue()).hashCode() : 0);
        return result;
    }
}

