/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.integer;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.integer.IntegerModificationFactory;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ModifiableInteger
extends ModifiableVariable<Integer>
implements Serializable {
    private Integer originalValue;

    @Override
    protected void createRandomModification() {
        VariableModification<Integer> vm = IntegerModificationFactory.createRandomModification();
        this.setModification(vm);
    }

    public Integer getAssertEquals() {
        return (Integer)this.assertEquals;
    }

    public void setAssertEquals(Integer assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        return this.getOriginalValue() != null && this.getOriginalValue().compareTo((Integer)this.getValue()) != 0;
    }

    public byte[] getByteArray(int size) {
        return ArrayConverter.intToBytes((Integer)this.getValue(), size);
    }

    @Override
    public boolean validateAssertions() {
        boolean valid = true;
        if (this.assertEquals != null && ((Integer)this.assertEquals).compareTo((Integer)this.getValue()) != 0) {
            valid = false;
        }
        return valid;
    }

    @Override
    public Integer getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(Integer originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableInteger{originalValue=" + this.originalValue + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifiableInteger)) {
            return false;
        }
        ModifiableInteger that = (ModifiableInteger)o;
        return this.getValue() != null ? ((Integer)this.getValue()).equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((Integer)this.getValue()).hashCode() : 0);
        return result;
    }
}

