/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.integer;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.integer.IntegerSubtractModification;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import java.util.Random;

@XmlRootElement
@XmlType(propOrder={"xor", "modificationFilter"})
public class IntegerXorModification
extends VariableModification<Integer> {
    private static final int MAX_VALUE_MODIFIER = 256;
    private Integer xor;

    public IntegerXorModification() {
    }

    public IntegerXorModification(Integer bi) {
        this.xor = bi;
    }

    @Override
    protected Integer modifyImplementationHook(Integer input) {
        return input == null ? this.xor : input ^ this.xor;
    }

    public Integer getXor() {
        return this.xor;
    }

    public void setXor(Integer xor) {
        this.xor = xor;
    }

    @Override
    public VariableModification<Integer> getModifiedCopy() {
        Random r = new Random();
        if (r.nextBoolean()) {
            return new IntegerSubtractModification(this.xor + new Random().nextInt(256));
        }
        return new IntegerSubtractModification(this.xor - new Random().nextInt(256));
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.xor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerXorModification other = (IntegerXorModification)obj;
        return Objects.equals(this.xor, other.xor);
    }
}

