/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Arrays;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ModifiableByteArray
extends ModifiableVariable<byte[]>
implements Serializable {
    private byte[] originalValue;

    @Override
    protected void createRandomModification() {
        VariableModification<byte[]> vm = ByteArrayModificationFactory.createRandomModification(this.originalValue);
        this.setModification(vm);
    }

    @Override
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    public byte[] getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(byte[] originalValue) {
        this.originalValue = originalValue;
    }

    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    public byte[] getAssertEquals() {
        return (byte[])this.assertEquals;
    }

    public void setAssertEquals(byte[] assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        return this.originalValue != null && !Arrays.equals(this.originalValue, (byte[])this.getValue());
    }

    @Override
    public boolean validateAssertions() {
        boolean valid = true;
        if (this.assertEquals != null && !Arrays.equals((byte[])this.assertEquals, (byte[])this.getValue())) {
            valid = false;
        }
        return valid;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isOriginalValueModified()) {
            result.append("Actual byte value is: ");
            result.append(ArrayConverter.bytesToHexString(this));
            result.append("\nOriginal value was: ");
            result.append(ArrayConverter.bytesToHexString(this.getOriginalValue()));
        } else {
            result.append("Original byte value is: ");
            result.append(ArrayConverter.bytesToHexString(this.getOriginalValue()));
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifiableByteArray)) {
            return false;
        }
        ModifiableByteArray that = (ModifiableByteArray)o;
        return Arrays.equals((byte[])this.getValue(), (byte[])that.getValue());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode((byte[])this.getValue());
        return result;
    }
}

