/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Random;

@XmlRootElement
@XmlType(propOrder={"xor", "startPosition", "modificationFilter"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ByteArrayXorModification
extends VariableModification<byte[]> {
    private static final int MAX_MODIFIER_VALUE = 256;
    private static final int MAX_XOR_MODIFIER = 32;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] xor;
    private int startPosition;

    public ByteArrayXorModification() {
    }

    public ByteArrayXorModification(byte[] xor, int startPosition) {
        this.xor = xor;
        this.startPosition = startPosition;
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        int end;
        if (input == null) {
            input = new byte[]{};
        }
        byte[] result = (byte[])input.clone();
        int start = this.startPosition;
        if (start < 0) {
            start += input.length;
        }
        if ((end = start + this.xor.length) > result.length) {
            LOGGER.debug(String.format("Input {%s} of length %d cannot be xor-ed with {%s} of length %d with start position %d", ArrayConverter.bytesToHexString(input), input.length, ArrayConverter.bytesToHexString(this.xor), this.xor.length, this.startPosition));
            return input;
        }
        for (int i = 0; i < this.xor.length; ++i) {
            result[start + i] = (byte)(input[start + i] ^ this.xor[i]);
        }
        return result;
    }

    public byte[] getXor() {
        return this.xor;
    }

    public void setXor(byte[] xor) {
        this.xor = xor;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    @Override
    public VariableModification<byte[]> getModifiedCopy() {
        Random r = new Random();
        if (r.nextBoolean()) {
            int index = r.nextInt(this.xor.length);
            byte[] newValue = Arrays.copyOf(this.xor, this.xor.length);
            newValue[index] = (byte)r.nextInt(256);
            return new ByteArrayXorModification(newValue, this.startPosition);
        }
        byte[] newValue = Arrays.copyOf(this.xor, this.xor.length);
        int modifier = r.nextInt(32);
        if (r.nextBoolean()) {
            modifier *= -1;
        }
        if ((modifier = this.startPosition + modifier) <= 0) {
            modifier = 1;
        }
        return new ByteArrayXorModification(newValue, modifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Arrays.hashCode(this.xor);
        hash = 97 * hash + this.startPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayXorModification other = (ByteArrayXorModification)obj;
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return Arrays.equals(this.xor, other.xor);
    }

    public String toString() {
        return "ByteArrayXorModification{xor=" + ArrayConverter.bytesToHexString(this.xor) + ", startPosition=" + this.startPosition + "}";
    }
}

