/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Random;

@XmlRootElement
@XmlType(propOrder={"shuffle", "modificationFilter"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ByteArrayShuffleModification
extends VariableModification<byte[]> {
    private static final int MAX_MODIFIER_VALUE = 256;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] shuffle;

    public ByteArrayShuffleModification() {
    }

    public ByteArrayShuffleModification(byte[] shuffle) {
        this.shuffle = shuffle;
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        if (input == null) {
            return input;
        }
        byte[] result = (byte[])input.clone();
        int size = input.length;
        if (size != 0) {
            for (int i = 0; i < this.shuffle.length - 1; i += 2) {
                int p1 = (this.shuffle[i] & 0xFF) % size;
                int p2 = (this.shuffle[i + 1] & 0xFF) % size;
                byte tmp = result[p1];
                result[p1] = result[p2];
                result[p2] = tmp;
            }
        }
        return result;
    }

    public byte[] getShuffle() {
        return this.shuffle;
    }

    public void setShuffle(byte[] shuffle) {
        this.shuffle = shuffle;
    }

    @Override
    public VariableModification<byte[]> getModifiedCopy() {
        Random r = new Random();
        int index = r.nextInt(this.shuffle.length);
        byte[] newValue = Arrays.copyOf(this.shuffle, this.shuffle.length);
        newValue[index] = (byte)r.nextInt(256);
        return new ByteArrayShuffleModification(this.shuffle);
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Arrays.hashCode(this.shuffle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayShuffleModification other = (ByteArrayShuffleModification)obj;
        return Arrays.equals(this.shuffle, other.shuffle);
    }

    public String toString() {
        return "ByteArrayShuffleModification{shuffle=" + ArrayConverter.bytesToHexString(this.shuffle) + "}";
    }
}

