/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayInsertModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;

@XmlRootElement
@XmlType(propOrder={"prependPayload", "payload", "appendPayload", "insert", "insertPosition", "modificationFilter"})
public class ByteArrayPayloadModification
extends VariableModification<byte[]> {
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] prependPayload = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] payload = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] appendPayload = new byte[0];
    private boolean insert = false;
    private int insertPosition = 0;

    public ByteArrayPayloadModification() {
    }

    public ByteArrayPayloadModification(byte[] payload) {
        this.payload = payload;
    }

    public ByteArrayPayloadModification(byte[] payload, int insertPosition) {
        this.payload = payload;
        this.insert = true;
        this.insertPosition = insertPosition;
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        byte[] completePayload = this.getCompletePayload();
        if (!this.insert) {
            return completePayload;
        }
        ByteArrayInsertModification insertMod = new ByteArrayInsertModification(completePayload, this.insertPosition);
        return insertMod.modify(input);
    }

    public byte[] getPrependPayload() {
        return this.prependPayload;
    }

    public void setPrependPayload(byte[] prependPayload) {
        this.prependPayload = prependPayload;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public byte[] getAppendPayload() {
        return this.appendPayload;
    }

    public void setAppendPayload(byte[] appendPayload) {
        this.appendPayload = appendPayload;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public int getInsertPosition() {
        return this.insertPosition;
    }

    public void setInsertPosition(int insertPosition) {
        this.insertPosition = insertPosition;
    }

    public byte[] getCompletePayload() {
        return ArrayConverter.concatenate(this.prependPayload, this.payload, this.appendPayload);
    }

    @Override
    public VariableModification<byte[]> getModifiedCopy() {
        ByteArrayPayloadModification mod = new ByteArrayPayloadModification(this.payload);
        mod.setAppendPayload(this.appendPayload);
        mod.setPrependPayload(this.prependPayload);
        if (this.insert) {
            mod.setInsert(true);
            mod.setInsertPosition(this.insertPosition);
            return mod;
        }
        return mod;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Arrays.hashCode(this.prependPayload);
        hash = 59 * hash + Arrays.hashCode(this.payload);
        hash = 59 * hash + Arrays.hashCode(this.appendPayload);
        hash = 59 * hash + (this.insert ? 1 : 0);
        hash = 59 * hash + this.insertPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayPayloadModification other = (ByteArrayPayloadModification)obj;
        if (this.insert != other.insert) {
            return false;
        }
        if (this.insertPosition != other.insertPosition) {
            return false;
        }
        if (!Arrays.equals(this.prependPayload, other.prependPayload)) {
            return false;
        }
        if (!Arrays.equals(this.payload, other.payload)) {
            return false;
        }
        return Arrays.equals(this.appendPayload, other.appendPayload);
    }

    public String toString() {
        return "ByteArrayPayloadModification{prependPayload=" + ArrayConverter.bytesToHexString(this.prependPayload) + ", payload=" + ArrayConverter.bytesToHexString(this.payload) + ", appendPayload=" + ArrayConverter.bytesToHexString(this.appendPayload) + ", insert=" + this.insert + ", insertPosition=" + this.insertPosition + "}";
    }
}

