/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerModificationFactory;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigInteger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ModifiableBigInteger
extends ModifiableVariable<BigInteger>
implements Serializable {
    private BigInteger originalValue;

    @Override
    protected void createRandomModification() {
        VariableModification<BigInteger> vm = BigIntegerModificationFactory.createRandomModification();
        this.setModification(vm);
    }

    public BigInteger getAssertEquals() {
        return (BigInteger)this.assertEquals;
    }

    public void setAssertEquals(BigInteger assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        return this.getOriginalValue() != null && this.getOriginalValue().compareTo((BigInteger)this.getValue()) != 0;
    }

    public byte[] getByteArray() {
        return ArrayConverter.bigIntegerToByteArray((BigInteger)this.getValue());
    }

    public byte[] getByteArray(int size) {
        return ArrayConverter.bigIntegerToByteArray((BigInteger)this.getValue(), size, true);
    }

    @Override
    public boolean validateAssertions() {
        return this.assertEquals == null || ((BigInteger)this.assertEquals).compareTo((BigInteger)this.getValue()) == 0;
    }

    @Override
    public BigInteger getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(BigInteger originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableBigInteger{originalValue=" + this.originalValue + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifiableBigInteger)) {
            return false;
        }
        ModifiableBigInteger that = (ModifiableBigInteger)o;
        return this.getValue() != null ? ((BigInteger)this.getValue()).equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((BigInteger)this.getValue()).hashCode() : 0);
        return result;
    }
}

