/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Random;

@XmlRootElement
@XmlType(propOrder={"xor", "modificationFilter"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BigIntegerXorModification
extends VariableModification<BigInteger> {
    private static final int MAX_XOR_LENGTH = 8;
    private BigInteger xor;

    public BigIntegerXorModification() {
    }

    public BigIntegerXorModification(BigInteger bi) {
        this.xor = bi;
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            input = BigInteger.ZERO;
        }
        return input.xor(this.xor);
    }

    public BigInteger getXor() {
        return this.xor;
    }

    public void setXor(BigInteger xor) {
        this.xor = xor;
    }

    @Override
    public VariableModification<BigInteger> getModifiedCopy() {
        return new BigIntegerXorModification(this.xor.add(new BigInteger(8, new Random())));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.xor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerXorModification other = (BigIntegerXorModification)obj;
        return Objects.equals(this.xor, other.xor);
    }
}

