/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Random;

@XmlRootElement
@XmlType(propOrder={"subtrahend", "modificationFilter"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BigIntegerSubtractModification
extends VariableModification<BigInteger> {
    private static final int MAX_SUBTRACT_LENGTH = 8;
    private BigInteger subtrahend;

    public BigIntegerSubtractModification() {
    }

    public BigIntegerSubtractModification(BigInteger bi) {
        this.subtrahend = bi;
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            input = BigInteger.ZERO;
        }
        return input.subtract(this.subtrahend);
    }

    public BigInteger getSubtrahend() {
        return this.subtrahend;
    }

    public void setSubtrahend(BigInteger subtrahend) {
        this.subtrahend = subtrahend;
    }

    @Override
    public VariableModification<BigInteger> getModifiedCopy() {
        return new BigIntegerSubtractModification(this.subtrahend.add(new BigInteger(8, new Random())));
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.subtrahend);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerSubtractModification other = (BigIntegerSubtractModification)obj;
        return Objects.equals(this.subtrahend, other.subtrahend);
    }
}

