/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigInteger;
import java.util.Random;

@XmlRootElement
@XmlType(propOrder={"shift", "modificationFilter"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BigIntegerShiftRightModification
extends VariableModification<BigInteger> {
    private static final int MAX_SHIFT_LENGTH = 32;
    private int shift;

    public BigIntegerShiftRightModification() {
    }

    public BigIntegerShiftRightModification(int shift) {
        this.shift = shift;
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            input = BigInteger.ZERO;
        }
        return input.shiftRight(this.shift);
    }

    public int getShift() {
        return this.shift;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    @Override
    public VariableModification<BigInteger> getModifiedCopy() {
        return new BigIntegerShiftRightModification(this.shift + new Random().nextInt(32));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.shift;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerShiftRightModification other = (BigIntegerShiftRightModification)obj;
        return this.shift == other.shift;
    }
}

