/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.VariableModification;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Random;

@XmlRootElement
@XmlType(propOrder={"factor", "modificationFilter"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BigIntegerMultiplyModification
extends VariableModification<BigInteger> {
    private static final int MAX_FACTOR_LENGTH = 8;
    private BigInteger factor;

    public BigIntegerMultiplyModification() {
    }

    public BigIntegerMultiplyModification(BigInteger bi) {
        this.factor = bi;
    }

    @Override
    protected BigInteger modifyImplementationHook(BigInteger input) {
        if (input == null) {
            input = BigInteger.ZERO;
        }
        return input.multiply(this.factor);
    }

    public BigInteger getFactor() {
        return this.factor;
    }

    public void setFactor(BigInteger factor) {
        this.factor = factor;
    }

    @Override
    public VariableModification<BigInteger> getModifiedCopy() {
        return new BigIntegerMultiplyModification(this.factor.add(new BigInteger(8, new Random())));
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.factor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerMultiplyModification other = (BigIntegerMultiplyModification)obj;
        return Objects.equals(this.factor, other.factor);
    }
}

