/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable;

import de.rub.nds.modifiablevariable.ModificationFilter;
import de.rub.nds.modifiablevariable.filter.AccessModificationFilter;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
@XmlTransient
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class VariableModification<E> {
    protected static final Logger LOGGER = LogManager.getLogger(VariableModification.class);
    @XmlElements(value={@XmlElement(type=AccessModificationFilter.class, name="AccessModificationFilter")})
    private ModificationFilter modificationFilter = null;

    public E modify(E input) {
        E modifiedValue = this.modifyImplementationHook(input);
        if (this.modificationFilter == null || !this.modificationFilter.filterModification()) {
            this.debug(modifiedValue);
            return modifiedValue;
        }
        return input;
    }

    protected abstract E modifyImplementationHook(E var1);

    public abstract VariableModification<E> getModifiedCopy();

    protected void debug(E value) {
        if (LOGGER.isDebugEnabled()) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            int index = 0;
            for (int i = 0; i < stack.length; ++i) {
                if (!stack[i].toString().contains("ModifiableVariable.getValue")) continue;
                index = i + 1;
            }
            String valueString = value.getClass().getSimpleName().equals("byte[]") ? ArrayConverter.bytesToHexString((byte[])value) : value.toString();
            LOGGER.debug("Using {} in function:\n  {}\n  New value: {}", (Object)this.getClass().getSimpleName(), (Object)stack[index], (Object)valueString);
        }
    }

    public ModificationFilter getModificationFilter() {
        return this.modificationFilter;
    }

    public void setModificationFilter(ModificationFilter modificationFilter) {
        this.modificationFilter = modificationFilter;
    }
}

