/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1tool.xmlparser;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.adapters.BigIntegerAdapter;
import de.rub.nds.asn1.model.Asn1Container;
import de.rub.nds.asn1tool.xmlparser.AnonymousIdentifier;
import de.rub.nds.asn1tool.xmlparser.Asn1XmlContent;
import de.rub.nds.asn1tool.xmlparser.JaxbClassList;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlParser {
    private JAXBContext jaxbContext = null;
    private Asn1XmlContent asn1XmlContent = null;
    private Map<String, Asn1Encodable> identifierMap = new HashMap<String, Asn1Encodable>();

    public XmlParser(String xml) {
        this.jaxbContext = this.createJaxbContext();
        this.parseXml(xml);
        this.crawlAsn1EncodedContent();
    }

    private JAXBContext createJaxbContext() {
        Class[] classes = JaxbClassList.getInstance().getClasses();
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])classes);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return jaxbContext;
    }

    private void parseXml(String xml) {
        try {
            StringReader stringReader = new StringReader(xml);
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            unmarshaller.setAdapter((XmlAdapter)new UnformattedByteArrayAdapter());
            unmarshaller.setAdapter((XmlAdapter)new BigIntegerAdapter());
            this.asn1XmlContent = (Asn1XmlContent)unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Is the root element of type Asn1XmlContent?", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void crawlAsn1EncodedContent() {
        List<Asn1Encodable> asn1Encodables = this.asn1XmlContent.getAsn1Encodables();
        this.crawlAsn1EncodedContentRecursive("", asn1Encodables);
    }

    private void crawlAsn1EncodedContentRecursive(String basePath, List<Asn1Encodable> asn1Encodables) {
        if (asn1Encodables != null) {
            for (Asn1Encodable asn1Encodable : asn1Encodables) {
                String identifier = this.indexAsn1Encodable(basePath, asn1Encodable);
                if (!(asn1Encodable instanceof Asn1Container)) continue;
                this.crawlAsn1EncodedContentRecursive(identifier, ((Asn1Container)asn1Encodable).getChildren());
            }
        }
    }

    private String indexAsn1Encodable(String basePath, Asn1Encodable asn1Encodable) {
        String fullPathIdentifier;
        if (asn1Encodable.getIdentifier() == null || asn1Encodable.getIdentifier().isEmpty()) {
            asn1Encodable.setIdentifier(AnonymousIdentifier.createAnonymousIdentifier());
        }
        if (this.identifierMap.containsKey(fullPathIdentifier = basePath + "/" + asn1Encodable.getIdentifier())) {
            throw new RuntimeException("Identifier " + fullPathIdentifier + " is used more than once!");
        }
        this.identifierMap.put(fullPathIdentifier, asn1Encodable);
        return fullPathIdentifier;
    }

    public Asn1XmlContent getAsn1XmlContent() {
        return this.asn1XmlContent;
    }

    public Map<String, Asn1Encodable> getIdentifierMap() {
        return this.identifierMap;
    }
}

