/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.util;

import de.rub.nds.asn1.Asn1Encodable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeParser {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean parseBooleanAttribute(Asn1Encodable asn1Encodable, String attributeName) {
        if (!asn1Encodable.hasAttribute(attributeName)) {
            throw new RuntimeException("Attribute " + attributeName + " not available!");
        }
        boolean result = Boolean.parseBoolean(asn1Encodable.getAttribute(attributeName));
        return result;
    }

    public static boolean parseBooleanAttributeOrDefault(Asn1Encodable asn1Encodable, String attributeName, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            result = AttributeParser.parseBooleanAttribute(asn1Encodable, attributeName);
        }
        catch (Throwable e) {
            LOGGER.debug(e.getMessage());
        }
        return result;
    }

    public static int parseIntAttribute(Asn1Encodable asn1Encodable, String attributeName) {
        if (!asn1Encodable.hasAttribute(attributeName)) {
            throw new RuntimeException("Attribute " + attributeName + " not available!");
        }
        int result = Integer.parseInt(asn1Encodable.getAttribute(attributeName));
        return result;
    }

    public static int parseIntAttributeOrDefault(Asn1Encodable asn1Encodable, String attributeName, int defaultValue) {
        int result = defaultValue;
        try {
            result = AttributeParser.parseIntAttribute(asn1Encodable, attributeName);
        }
        catch (Throwable e) {
            LOGGER.debug(e.getMessage());
        }
        return result;
    }

    public static long parseLongAttribute(Asn1Encodable asn1Encodable, String attributeName) {
        if (!asn1Encodable.hasAttribute(attributeName)) {
            throw new RuntimeException("Attribute " + attributeName + " not available!");
        }
        long result = Long.parseLong(asn1Encodable.getAttribute(attributeName));
        return result;
    }

    public static long parseLongAttributeOrDefault(Asn1Encodable asn1Encodable, String attributeName, long defaultValue) {
        long result = defaultValue;
        try {
            result = AttributeParser.parseLongAttribute(asn1Encodable, attributeName);
        }
        catch (Throwable e) {
            LOGGER.debug(e.getMessage());
        }
        return result;
    }

    public static String parseStringAttribute(Asn1Encodable asn1Encodable, String attributeName) {
        if (!asn1Encodable.hasAttribute(attributeName)) {
            throw new RuntimeException("Attribute " + attributeName + " not available!");
        }
        String result = asn1Encodable.getAttribute(attributeName);
        return result;
    }

    public static String parseStringAttributeOrDefault(Asn1Encodable asn1Encodable, String attributeName, String defaultValue) {
        String result = defaultValue;
        try {
            result = AttributeParser.parseStringAttribute(asn1Encodable, attributeName);
        }
        catch (Throwable e) {
            LOGGER.debug(e.getMessage());
        }
        return result;
    }
}

