/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.translator.fieldtranslators;

import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.parser.IntermediateAsn1Field;
import de.rub.nds.asn1.translator.fieldtranslators.Asn1FieldFT;

public final class Asn1ObjectIdentifierFT
extends Asn1FieldFT<Asn1ObjectIdentifier> {
    private final IntermediateAsn1Field intermediateAsn1Field;
    private final Asn1ObjectIdentifier asn1ObjectIdentifier;

    public Asn1ObjectIdentifierFT(IntermediateAsn1Field intermediateAsn1Field) {
        this(intermediateAsn1Field, new Asn1ObjectIdentifier());
    }

    protected Asn1ObjectIdentifierFT(IntermediateAsn1Field intermediateAsn1Field, Asn1ObjectIdentifier asn1ObjectIdentifier) {
        super(intermediateAsn1Field, asn1ObjectIdentifier);
        this.intermediateAsn1Field = intermediateAsn1Field;
        this.asn1ObjectIdentifier = asn1ObjectIdentifier;
    }

    @Override
    public Asn1ObjectIdentifier translate(String identifier, String type) {
        String value = this.decodeValue(this.intermediateAsn1Field.getContent());
        this.asn1ObjectIdentifier.setValue(value);
        return (Asn1ObjectIdentifier)super.translate(identifier, type);
    }

    private String decodeValue(byte[] content) {
        Object result = "";
        if (content.length > 0) {
            result = (String)result + content[0] / 40 + "." + content[0] % 40;
            int contentPos = 1;
            while (contentPos < content.length) {
                boolean partFinished;
                long oidPart = 0L;
                do {
                    oidPart = oidPart << 7 | (long)(content[contentPos] & 0x7F);
                    boolean bl = partFinished = (content[contentPos] & 0x80) == 0;
                } while (++contentPos < content.length && !partFinished);
                result = (String)result + "." + oidPart;
            }
        }
        return result;
    }
}

