/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.serializer;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1tool.xmlparser.JaxbClassList;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Asn1EncodableSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static JAXBContext context;

    private static synchronized JAXBContext getJAXBContext() throws JAXBException, IOException {
        if (context == null) {
            Class[] classes = JaxbClassList.getInstance().getClasses();
            context = JAXBContext.newInstance((Class[])classes);
        }
        return context;
    }

    public static void write(OutputStream outputStream, Asn1Encodable asn1Encdoable) throws JAXBException, IOException {
        context = Asn1EncodableSerializer.getJAXBContext();
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)asn1Encdoable, outputStream);
        outputStream.close();
    }

    public static Asn1Encodable read(InputStream inputStream) throws JAXBException, IOException, XMLStreamException {
        context = Asn1EncodableSerializer.getJAXBContext();
        Unmarshaller m = context.createUnmarshaller();
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
        Asn1Encodable asn1 = (Asn1Encodable)m.unmarshal(xsr);
        inputStream.close();
        return asn1;
    }

    public static Asn1Encodable copyAsn1Encodable(Asn1Encodable asn1Encodable) throws JAXBException, IOException, XMLStreamException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Asn1EncodableSerializer.write(stream, asn1Encodable);
        stream.flush();
        Asn1Encodable copiedAsn1Encodable = Asn1EncodableSerializer.read(new ByteArrayInputStream(stream.toByteArray()));
        return copiedAsn1Encodable;
    }

    private Asn1EncodableSerializer() {
    }
}

