/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.model;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.serializer.Asn1EncodableSerializer;
import de.rub.nds.asn1.serializer.Asn1RawFieldSerializer;
import de.rub.nds.asn1.serializer.Asn1Serializer;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Asn1RawField
implements Asn1Encodable {
    @XmlAttribute(name="identifier")
    private String identifier = "";
    @XmlAttribute(name="type")
    private String type = "";
    @XmlAnyAttribute
    private Map<QName, String> attributes = new HashMap<QName, String>();
    @XmlElement(name="identifierOctets")
    private ModifiableByteArray identifierOctets = new ModifiableByteArray();
    @XmlElement(name="lengthOctets")
    private ModifiableByteArray lengthOctets = new ModifiableByteArray();
    @XmlElement(name="contentOctets")
    private ModifiableByteArray contentOctets = new ModifiableByteArray();

    public Asn1RawField() {
        this.identifierOctets.setOriginalValue(new byte[0]);
        this.lengthOctets.setOriginalValue(new byte[0]);
        this.contentOctets.setOriginalValue(new byte[0]);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public Map<QName, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<QName, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        return this.attributes.containsKey(new QName(attributeName));
    }

    @Override
    public String getAttribute(String attributeName) {
        String attribute = null;
        QName attributeQName = new QName(attributeName);
        if (this.attributes.containsKey(attributeQName)) {
            attribute = this.attributes.get(attributeQName);
        }
        return attribute;
    }

    @Override
    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(new QName(attributeName), attributeValue);
    }

    public ModifiableByteArray getIdentifierOctets() {
        return this.identifierOctets;
    }

    public void setIdentifierOctets(ModifiableByteArray identifierOctets) {
        this.identifierOctets = identifierOctets;
    }

    public void setIdentifierOctets(byte[] identifierOctets) {
        this.identifierOctets = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.identifierOctets, (byte[])identifierOctets);
    }

    public ModifiableByteArray getLengthOctets() {
        return this.lengthOctets;
    }

    public void setLengthOctets(ModifiableByteArray lengthOctets) {
        this.lengthOctets = lengthOctets;
    }

    public void setLengthOctets(byte[] lengthOctets) {
        this.lengthOctets = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.lengthOctets, (byte[])lengthOctets);
    }

    public ModifiableByteArray getContentOctets() {
        return this.contentOctets;
    }

    public void setContentOctets(ModifiableByteArray contentOctets) {
        this.contentOctets = contentOctets;
    }

    public void setContentOctets(byte[] contentOctets) {
        this.contentOctets = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.contentOctets, (byte[])contentOctets);
    }

    @Override
    public Asn1Serializer getSerializer() {
        return new Asn1RawFieldSerializer(this);
    }

    @Override
    public Asn1Encodable getCopy() throws JAXBException, IOException, XMLStreamException {
        return Asn1EncodableSerializer.copyAsn1Encodable(this);
    }
}

