/*
 * Decompiled with CFR 0.152.
 */
package de.is24.maven.enforcer.rules;

import de.is24.maven.enforcer.rules.ClassFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class Repository {
    private final Set<String> types = new HashSet<String>();
    private final Set<String> dependencies = new HashSet<String>();
    private final ClassFilter filter;

    Repository(ClassFilter filter) {
        this.filter = filter;
    }

    Set<String> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    Set<String> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    void addType(String type) {
        this.filter.addFiltered(this.types, type);
    }

    void addDependency(String type) {
        this.filter.addFiltered(this.dependencies, type);
    }

    public String toString() {
        return String.format("Repository{types=%s, dependencies=%s}", this.types, this.dependencies);
    }
}

