/*
 * Decompiled with CFR 0.152.
 */
package de.is24.maven.enforcer.rules;

import de.is24.maven.enforcer.rules.ClassDependencyResolvingVisitor;
import de.is24.maven.enforcer.rules.ClassFilter;
import de.is24.maven.enforcer.rules.Repository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

final class ArtifactRepositoryAnalyzer {
    private static final String CLASS_SUFFIX = ".class";
    private static final Pattern JAR_FILE_PATTERN = Pattern.compile("^.+\\.(jar|war|JAR|WAR)$");
    private final Log logger;
    private final boolean analyzeDependencies;
    private final ClassFilter filter;

    private ArtifactRepositoryAnalyzer(Log logger, boolean analyzeDependencies, ClassFilter filter) {
        this.logger = logger;
        this.analyzeDependencies = analyzeDependencies;
        this.filter = filter;
    }

    static ArtifactRepositoryAnalyzer analyzeArtifacts(Log logger, boolean analyzeDependencies, ClassFilter filter) {
        return new ArtifactRepositoryAnalyzer(logger, analyzeDependencies, filter);
    }

    Repository analyzeArtifacts(Iterable<Artifact> artifacts) {
        Repository repository = new Repository(this.filter);
        for (Artifact artifact : artifacts) {
            File artifactFile = artifact.getFile();
            if (artifactFile == null) {
                this.logger.info((CharSequence)("Artifact '" + artifact + "' has no associated file, skip it."));
                continue;
            }
            if (artifactFile.isDirectory()) {
                this.analyzeClassesDirectory(repository, artifactFile);
                continue;
            }
            String absolutePath = artifactFile.getAbsolutePath();
            if (JAR_FILE_PATTERN.matcher(absolutePath).matches()) {
                this.analyzeJar(repository, artifactFile);
                continue;
            }
            this.logger.info((CharSequence)("Artifact '" + artifact + "' associated file '" + absolutePath + "', is skipped."));
        }
        return repository;
    }

    private void analyzeJar(Repository repository, File jar) {
        ClassDependencyResolvingVisitor classVisitor = new ClassDependencyResolvingVisitor(repository, this.logger);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar.getAbsolutePath());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String fileName = entry.getName();
                if (!fileName.endsWith(CLASS_SUFFIX)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((CharSequence)("Analyze class '" + fileName + "' in JAR '" + jar + "'."));
                }
                ClassReader classReader = new ClassReader(zipFile.getInputStream(entry));
                String className = classReader.getClassName().replace('/', '.');
                if (this.analyzeDependencies) {
                    if (!this.filter.isConsideredType(className)) continue;
                    classReader.accept((ClassVisitor)classVisitor, 4);
                    continue;
                }
                repository.addType(className);
            }
        }
        catch (IOException e) {
            throw this.logAndWrapIOException(e, jar, "artifact");
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    throw this.logAndWrapIOException(e, jar, "artifact");
                }
            }
        }
    }

    private IllegalStateException logAndWrapIOException(IOException e, File file, String description) {
        String error = "Unable to read class(es) from " + description + " '" + file + "'.";
        this.logger.error((CharSequence)error, (Throwable)e);
        return new IllegalStateException(error, e);
    }

    private void analyzeClassesDirectory(Repository repository, File classesDirectory) {
        ClassDependencyResolvingVisitor classVisitor = new ClassDependencyResolvingVisitor(repository, this.logger);
        this.analyzeClassesDirectory(repository, classesDirectory, classVisitor);
    }

    private void analyzeClassesDirectory(Repository repository, File directory, ClassVisitor classVisitor) {
        String path;
        if (directory.isDirectory()) {
            String[] entries;
            for (String entry : entries = directory.list()) {
                this.analyzeClassesDirectory(repository, new File(directory, entry), classVisitor);
            }
        }
        if ((path = directory.getPath()).endsWith(CLASS_SUFFIX)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((CharSequence)("Analyze class '" + path + "'."));
            }
            FileInputStream classFileStream = null;
            try {
                classFileStream = new FileInputStream(directory);
                ClassReader classReader = new ClassReader((InputStream)classFileStream);
                String className = classReader.getClassName().replace('/', '.');
                if (this.analyzeDependencies) {
                    if (this.filter.isConsideredType(className)) {
                        classReader.accept(classVisitor, 4);
                    }
                } else {
                    repository.addType(className);
                }
            }
            catch (IOException e) {
                throw this.logAndWrapIOException(e, directory, "file");
            }
            finally {
                try {
                    if (classFileStream != null) {
                        classFileStream.close();
                    }
                }
                catch (IOException e) {
                    throw this.logAndWrapIOException(e, directory, "file");
                }
            }
        }
    }
}

