/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import java.util.Arrays;
import java.util.Random;

public class ByteArrayTools {
    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] copy(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] copy(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] createBytes(int n, byte by) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return byArray;
    }

    public static byte[] createRandomBytes(int n) {
        Random random = new Random(System.currentTimeMillis());
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        return byArray;
    }

    public static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length - n < n3 || byArray2.length - n2 < n3) {
            return false;
        }
        if (n3 == 0) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static int indexOf(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5) {
        if (n5 >= n2) {
            return n4 == 0 ? n2 : -1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 == 0) {
            return n5;
        }
        byte by = byArray2[n3];
        int n6 = n + (n2 - n4);
        int n7 = n + n5;
        while (n7 <= n6) {
            if (byArray[n7] != by) {
                while (++n7 <= n6 && byArray[n7] != by) {
                }
            }
            if (n7 <= n6) {
                int n8 = n7 + 1;
                int n9 = n8 + n4 - 1;
                int n10 = n3 + 1;
                while (n8 < n9 && byArray[n8] == byArray2[n10]) {
                    ++n8;
                    ++n10;
                }
                if (n8 == n9) {
                    return n7 - n;
                }
            }
            ++n7;
        }
        return -1;
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return false;
        }
        if (byArray2 == null) {
            return true;
        }
        int n = byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void toBigEndianArray(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n3 - 1;
        while (n5 >= 0) {
            byArray[n5 + n] = (byte)(n2 >>> n4 & 0xFF);
            n4 += 8;
            --n5;
        }
    }

    public static byte[] toBigEndianArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            byArray[n4] = (byte)(n >>> n3 & 0xFF);
            n3 += 8;
            --n4;
        }
        return byArray;
    }

    public static int toBigEndianInteger(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 8 * (n2 - n4 - 1);
            n3 |= (byArray[n + n4] & 0xFF) << n5;
            ++n4;
        }
        return n3;
    }

    public static void toLittleEndianArray(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 8 * n4;
            byArray[n4 + n] = (byte)(n2 >>> n5 & 0xFF);
            ++n4;
        }
    }

    public static void toLittleEndianArray(byte[] byArray, int n, long l, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 8 * n3;
            byArray[n3 + n] = (byte)(l >>> n4 & 0xFFL);
            ++n3;
        }
    }

    public static byte[] toLittleEndianArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 8 * n3;
            byArray[n3] = (byte)(n >>> n4 & 0xFF);
            ++n3;
        }
        return byArray;
    }

    public static byte[] toLittleEndianArray(long l, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 8 * n2;
            byArray[n2] = (byte)(l >>> n3 & 0xFFL);
            ++n2;
        }
        return byArray;
    }

    public static int toLittleEndianInteger(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 8 * n4;
            n3 |= (byArray[n + n4] & 0xFF) << n5;
            ++n4;
        }
        return n3;
    }

    public static long toLittleEndianLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 8 * n3;
            l |= (long)((byArray[n + n3] & 0xFF) << n4);
            ++n3;
        }
        return l;
    }
}

