/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtractedFileSets {
    private static Logger logger = LoggerFactory.getLogger(ExtractedFileSets.class);

    private ExtractedFileSets() {
    }

    public static ExtractedFileSet copy(ExtractedFileSet src, Directory directory, TempNaming executableNaming) throws IOException {
        File destination = directory.asFile();
        File baseDir = src.baseDir();
        File oldExe = src.executable();
        ImmutableExtractedFileSet.Builder builder = ExtractedFileSet.builder(destination).baseDirIsGenerated(directory.isGenerated());
        de.flapdoodle.embed.process.io.file.Files.createOrCheckDir(de.flapdoodle.embed.process.io.file.Files.fileOf(destination, oldExe).getParentFile());
        File source = de.flapdoodle.embed.process.io.file.Files.fileOf(baseDir, oldExe);
        Path newExeFile = de.flapdoodle.embed.process.io.file.Files.fileOf(destination, executableNaming.nameFor("extract", oldExe.getName())).toPath();
        if (!Files.exists(newExeFile, new LinkOption[0]) || !de.flapdoodle.embed.process.io.file.Files.sameContent(source.toPath(), newExeFile)) {
            Files.copy(source.toPath(), newExeFile, StandardCopyOption.REPLACE_EXISTING);
        }
        builder.executable(newExeFile.toFile());
        for (File srcFile : src.libraryFiles()) {
            File destinationFile = de.flapdoodle.embed.process.io.file.Files.fileOf(destination, srcFile);
            de.flapdoodle.embed.process.io.file.Files.createOrCheckDir(destinationFile.getParentFile());
            Path newFile = Files.copy(de.flapdoodle.embed.process.io.file.Files.fileOf(baseDir, srcFile).toPath(), destinationFile.toPath(), new CopyOption[0]);
            builder.addLibraryFiles(newFile.toFile());
        }
        return builder.build();
    }

    public static void delete(ExtractedFileSet all) {
        for (File file : all.libraryFiles()) {
            if (!file.exists() || de.flapdoodle.embed.process.io.file.Files.forceDelete(file)) continue;
            logger.warn("Could not delete {} NOW: {}", (Object)file);
        }
        File exe = all.executable();
        if (exe.exists() && !de.flapdoodle.embed.process.io.file.Files.forceDelete(exe)) {
            logger.warn("Could not delete executable NOW: {}", (Object)exe);
        }
        if (all.baseDirIsGenerated() && !de.flapdoodle.embed.process.io.file.Files.forceDelete(all.baseDir())) {
            logger.warn("Could not delete generatedBaseDir: {}", (Object)all.baseDir());
        }
    }
}

