/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import marytts.util.math.ComplexNumber;

public class ArrayUtils {
    public static double[] copy(double[] orig) {
        if (orig != null) {
            return ArrayUtils.subarray(orig, 0, orig.length);
        }
        return null;
    }

    public static byte[] copy(byte[] orig) {
        if (orig != null) {
            return ArrayUtils.subarray(orig, 0, orig.length);
        }
        return null;
    }

    public static short[] copy(short[] orig) {
        if (orig != null) {
            return ArrayUtils.subarray(orig, 0, orig.length);
        }
        return null;
    }

    public static float[] copy(float[] orig) {
        if (orig != null) {
            return ArrayUtils.subarray(orig, 0, orig.length);
        }
        return null;
    }

    public static char[] copy(char[] orig) {
        if (orig != null) {
            return ArrayUtils.subarray(orig, 0, orig.length);
        }
        return null;
    }

    public static int[] copy(int[] orig) {
        if (orig != null) {
            return ArrayUtils.subarray(orig, 0, orig.length);
        }
        return null;
    }

    public static double[] copyFloat2Double(float[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayFloat2Double(orig, 0, orig.length);
        }
        return null;
    }

    public static short[] copyFloat2Short(float[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayFloat2Short(orig, 0, orig.length);
        }
        return null;
    }

    public static double[] copyShort2Double(short[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayShort2Double(orig, 0, orig.length);
        }
        return null;
    }

    public static float[] copyShort2Float(short[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayShort2Float(orig, 0, orig.length);
        }
        return null;
    }

    public static float[] copyDouble2Float(double[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayDouble2Float(orig, 0, orig.length);
        }
        return null;
    }

    public static float[] copyChar2Float(char[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayChar2Float(orig, 0, orig.length);
        }
        return null;
    }

    public static double[] copyChar2Double(char[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayChar2Double(orig, 0, orig.length);
        }
        return null;
    }

    public static float[] copyByte2Float(byte[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayByte2Float(orig, 0, orig.length);
        }
        return null;
    }

    public static double[] copyByte2Double(byte[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayByte2Double(orig, 0, orig.length);
        }
        return null;
    }

    public static short[] copyDouble2Short(double[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayDouble2Short(orig, 0, orig.length);
        }
        return null;
    }

    public static char[] copyDouble2Char(double[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayDouble2Char(orig, 0, orig.length);
        }
        return null;
    }

    public static char[] copyFloat2Char(float[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayFloat2Char(orig, 0, orig.length);
        }
        return null;
    }

    public static byte[] copyDouble2Byte(double[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayDouble2Byte(orig, 0, orig.length);
        }
        return null;
    }

    public static byte[] copyFloat2Byte(float[] orig) {
        if (orig != null) {
            return ArrayUtils.subarrayFloat2Byte(orig, 0, orig.length);
        }
        return null;
    }

    public static ComplexNumber[] copy(ComplexNumber[] orig) {
        ComplexNumber[] out = null;
        if (orig != null) {
            out = new ComplexNumber[orig.length];
            int i = 0;
            while (i < orig.length) {
                out[i] = new ComplexNumber(orig[i]);
                ++i;
            }
        }
        return out;
    }

    public static double[] subarray(double[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        double[] sub = new double[len];
        System.arraycopy(orig, off, sub, 0, len);
        return sub;
    }

    public static byte[] subarray(byte[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        byte[] sub = new byte[len];
        System.arraycopy(orig, off, sub, 0, len);
        return sub;
    }

    public static float[] subarray(float[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        float[] sub = new float[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static char[] subarray(char[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        char[] sub = new char[len];
        System.arraycopy(orig, off, sub, 0, len);
        return sub;
    }

    public static short[] subarray(short[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        short[] sub = new short[len];
        System.arraycopy(orig, off, sub, 0, len);
        return sub;
    }

    public static int[] subarray(int[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        int[] sub = new int[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static double[] subarrayShort2Double(short[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        double[] sub = new double[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static float[] subarrayShort2Float(short[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        float[] sub = new float[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static double[] subarrayChar2Double(char[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        double[] sub = new double[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static float[] subarrayChar2Float(char[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        float[] sub = new float[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static double[] subarrayByte2Double(byte[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        double[] sub = new double[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static float[] subarrayByte2Float(byte[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        float[] sub = new float[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static short[] subarrayDouble2Short(double[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        short[] sub = new short[len];
        int i = 0;
        while (i < len) {
            sub[i] = (short)orig[i + off];
            ++i;
        }
        return sub;
    }

    public static char[] subarrayDouble2Char(double[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        char[] sub = new char[len];
        int i = 0;
        while (i < len) {
            sub[i] = (char)orig[i + off];
            ++i;
        }
        return sub;
    }

    public static char[] subarrayFloat2Char(float[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        char[] sub = new char[len];
        int i = 0;
        while (i < len) {
            sub[i] = (char)orig[i + off];
            ++i;
        }
        return sub;
    }

    public static byte[] subarrayDouble2Byte(double[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        byte[] sub = new byte[len];
        int i = 0;
        while (i < len) {
            sub[i] = (byte)orig[i + off];
            ++i;
        }
        return sub;
    }

    public static byte[] subarrayFloat2Byte(float[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        byte[] sub = new byte[len];
        int i = 0;
        while (i < len) {
            sub[i] = (byte)orig[i + off];
            ++i;
        }
        return sub;
    }

    public static double[] subarrayFloat2Double(float[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        double[] sub = new double[len];
        int i = 0;
        while (i < len) {
            sub[i] = orig[i + off];
            ++i;
        }
        return sub;
    }

    public static short[] subarrayFloat2Short(float[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        short[] sub = new short[len];
        int i = 0;
        while (i < len) {
            sub[i] = (short)orig[i + off];
            ++i;
        }
        return sub;
    }

    public static float[] subarrayDouble2Float(double[] orig, int off, int len) {
        if (off + len > orig.length) {
            throw new IllegalArgumentException("requested subarray exceeds array length");
        }
        float[] sub = new float[len];
        int i = 0;
        while (i < len) {
            sub[i] = (float)orig[i + off];
            ++i;
        }
        return sub;
    }

    public static boolean isOneOf(int[] array, int val) {
        boolean ret = false;
        int i = 0;
        while (i < array.length) {
            if (array[i] == val) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    public static int[] appendToStart(int[] array, int val) {
        int len = 1;
        if (array != null) {
            len += array.length;
        }
        int[] arrayOut = new int[len];
        arrayOut[0] = val;
        if (array != null) {
            System.arraycopy(array, 0, arrayOut, 1, array.length);
        }
        return arrayOut;
    }

    public static int[] appendToEnd(int[] array, int val) {
        int len = 1;
        if (array != null) {
            len += array.length;
        }
        int[] arrayOut = new int[len];
        arrayOut[len - 1] = val;
        if (array != null) {
            System.arraycopy(array, 0, arrayOut, 0, array.length);
        }
        return arrayOut;
    }

    public static float[] combine(float[] x, float[] y) {
        int len = 0;
        if (x != null) {
            len += x.length;
        }
        if (y != null) {
            len += y.length;
        }
        float[] z = null;
        if (len > 0) {
            z = new float[len];
            int currentPos = 0;
            if (x != null) {
                System.arraycopy(x, 0, z, currentPos, x.length);
                currentPos = x.length;
            }
            if (y != null) {
                System.arraycopy(y, 0, z, currentPos, y.length);
            }
        }
        return z;
    }

    public static double[] combine(double[] x, double[] y) {
        int len = 0;
        if (x != null) {
            len += x.length;
        }
        if (y != null) {
            len += y.length;
        }
        double[] z = null;
        if (len > 0) {
            z = new double[len];
            int currentPos = 0;
            if (x != null) {
                System.arraycopy(x, 0, z, currentPos, x.length);
                currentPos = x.length;
            }
            if (y != null) {
                System.arraycopy(y, 0, z, currentPos, y.length);
            }
        }
        return z;
    }

    public static boolean isZero(float[] array) {
        boolean isZero = true;
        int j = 0;
        while (j < array.length) {
            if (array[j] != 0.0f) {
                isZero = false;
                break;
            }
            ++j;
        }
        return isZero;
    }

    public static boolean isZero(double[] array) {
        boolean isZero = true;
        int j = 0;
        while (j < array.length) {
            if (array[j] != 0.0) {
                isZero = false;
                break;
            }
            ++j;
        }
        return isZero;
    }
}

