/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.EnergyAnalyser;
import marytts.signalproc.filter.LowPassFilter;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.AudioProcessor;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.data.audio.MonoAudioInputStream;
import marytts.util.signal.SignalProcUtils;

public class AudioConverterUtils {
    public static AudioInputStream convertBit24ToBit16(AudioInputStream ais) throws Exception {
        int bitsPerSample = 24;
        int targetBitsPerSample = 16;
        int noOfbitsPerSample = ais.getFormat().getSampleSizeInBits();
        if (noOfbitsPerSample != bitsPerSample) {
            throw new Exception("24-Bit Audio Data Expected. But given Audio Data is " + noOfbitsPerSample + "-Bit data");
        }
        if (ais.getFormat().getChannels() != 1) {
            throw new Exception("Expected Audio type is Mono. But given Audio Data has " + ais.getFormat().getChannels() + " channels");
        }
        float samplingRate = ais.getFormat().getSampleRate();
        int channels = ais.getFormat().getChannels();
        int nBytes = ais.available();
        boolean bigEndian = ais.getFormat().isBigEndian();
        byte[] byteBuf = new byte[nBytes];
        int nBytesRead = ais.read(byteBuf, 0, nBytes);
        int currentPos = 0;
        int noOfSamples = nBytes / 3;
        int[] sample = new int[noOfSamples];
        int i = 0;
        while (i < nBytesRead) {
            byte hibyte;
            byte midbyte;
            byte lobyte;
            if (!bigEndian) {
                lobyte = byteBuf[i];
                midbyte = byteBuf[i + 1];
                hibyte = byteBuf[i + 2];
            } else {
                lobyte = byteBuf[i + 2];
                midbyte = byteBuf[i + 1];
                hibyte = byteBuf[i];
            }
            sample[currentPos] = hibyte << 16 | (midbyte & 0xFF) << 8 | lobyte & 0xFF;
            i += 3;
            ++currentPos;
        }
        int maxBitPos = 0;
        int i2 = 0;
        while (i2 < sample.length) {
            int j = bitsPerSample;
            while (j >= 1) {
                int valueAfterShift = Math.abs(sample[i2]) >> j;
                if (valueAfterShift != 0) {
                    if (maxBitPos >= j) break;
                    maxBitPos = j;
                    break;
                }
                --j;
            }
            ++i2;
        }
        int shiftBits = maxBitPos - targetBitsPerSample + 2;
        int i3 = 0;
        while (shiftBits > 0 && i3 < sample.length) {
            int sign = sample[i3] < 0 ? -1 : 1;
            sample[i3] = sign * (Math.abs(sample[i3]) >> shiftBits);
            ++i3;
        }
        currentPos = 0;
        int nRead = sample.length;
        byte[] b = new byte[2 * sample.length];
        int MAX_AMPLITUDE = Short.MAX_VALUE;
        int i4 = 0;
        while (i4 < nRead) {
            int samp = sample[i4];
            if (samp > MAX_AMPLITUDE || samp < -MAX_AMPLITUDE) {
                System.err.println("Warning: signal amplitude out of range: " + samp);
            }
            byte hibyte = (byte)(samp >> 8);
            byte lobyte = (byte)(samp & 0xFF);
            if (!bigEndian) {
                b[currentPos] = lobyte;
                b[currentPos + 1] = hibyte;
            } else {
                b[currentPos] = hibyte;
                b[currentPos + 1] = lobyte;
            }
            ++i4;
            currentPos += 2;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        boolean signed = true;
        AudioFormat af = new AudioFormat(samplingRate, targetBitsPerSample, channels, signed, bigEndian);
        long lengthInSamples = b.length / (targetBitsPerSample / 8);
        return new AudioInputStream(bais, af, lengthInSamples);
    }

    public static AudioInputStream convertBit24ToBit16(AudioInputStream ais, int shiftBits) throws Exception {
        int bitsPerSample = 24;
        int targetBitsPerSample = 16;
        int noOfbitsPerSample = ais.getFormat().getSampleSizeInBits();
        if (noOfbitsPerSample != bitsPerSample) {
            throw new Exception("24-Bit Audio Data Expected. But given Audio Data is " + noOfbitsPerSample + "-Bit data");
        }
        if (ais.getFormat().getChannels() != 1) {
            throw new Exception("Expected Audio type is Mono. But given Audio Data has " + ais.getFormat().getChannels() + " channels");
        }
        float samplingRate = ais.getFormat().getSampleRate();
        int channels = ais.getFormat().getChannels();
        int nBytes = ais.available();
        boolean bigEndian = ais.getFormat().isBigEndian();
        byte[] byteBuf = new byte[nBytes];
        int nBytesRead = ais.read(byteBuf, 0, nBytes);
        int currentPos = 0;
        int noOfSamples = nBytes / 3;
        int[] sample = new int[noOfSamples];
        int i = 0;
        while (i < nBytesRead) {
            byte hibyte;
            byte midbyte;
            byte lobyte;
            if (!bigEndian) {
                lobyte = byteBuf[i];
                midbyte = byteBuf[i + 1];
                hibyte = byteBuf[i + 2];
            } else {
                lobyte = byteBuf[i + 2];
                midbyte = byteBuf[i + 1];
                hibyte = byteBuf[i];
            }
            sample[currentPos] = hibyte << 16 | (midbyte & 0xFF) << 8 | lobyte & 0xFF;
            i += 3;
            ++currentPos;
        }
        int i2 = 0;
        while (shiftBits > 0 && i2 < sample.length) {
            int sign = sample[i2] < 0 ? -1 : 1;
            sample[i2] = sign * (Math.abs(sample[i2]) >> shiftBits);
            ++i2;
        }
        currentPos = 0;
        int nRead = sample.length;
        byte[] b = new byte[2 * sample.length];
        int MAX_AMPLITUDE = Short.MAX_VALUE;
        int i3 = 0;
        while (i3 < nRead) {
            int samp = sample[i3];
            if (samp > MAX_AMPLITUDE || samp < -MAX_AMPLITUDE) {
                System.err.println("Warning: signal amplitude out of range: " + samp);
            }
            byte hibyte = (byte)(samp >> 8);
            byte lobyte = (byte)(samp & 0xFF);
            if (!bigEndian) {
                b[currentPos] = lobyte;
                b[currentPos + 1] = hibyte;
            } else {
                b[currentPos] = hibyte;
                b[currentPos + 1] = lobyte;
            }
            ++i3;
            currentPos += 2;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        boolean signed = true;
        AudioFormat af = new AudioFormat(samplingRate, targetBitsPerSample, channels, signed, bigEndian);
        long lengthInSamples = b.length / (targetBitsPerSample / 8);
        return new AudioInputStream(bais, af, lengthInSamples);
    }

    public static int[] getSamples(AudioInputStream ais) throws Exception {
        int noOfbitsPerSample = ais.getFormat().getSampleSizeInBits();
        ais.getFormat().getSampleRate();
        ais.getFormat().getChannels();
        int nBytes = ais.available();
        boolean bigEndian = ais.getFormat().isBigEndian();
        byte[] byteBuf = new byte[nBytes];
        int nBytesRead = ais.read(byteBuf, 0, nBytes);
        int noOfBytesPerSample = noOfbitsPerSample / 8;
        int[] samples = new int[nBytes / noOfBytesPerSample];
        int currentPos = 0;
        if (noOfBytesPerSample == 1) {
            int i = 0;
            while (i < nBytesRead) {
                samples[currentPos] = byteBuf[i] << 8;
                ++i;
                ++currentPos;
            }
        } else if (noOfBytesPerSample == 2) {
            int i = 0;
            while (i < nBytesRead) {
                byte hibyte;
                byte lobyte;
                if (!bigEndian) {
                    lobyte = byteBuf[i];
                    hibyte = byteBuf[i + 1];
                } else {
                    lobyte = byteBuf[i + 1];
                    hibyte = byteBuf[i];
                }
                samples[currentPos] = hibyte << 8 | lobyte & 0xFF;
                i += 2;
                ++currentPos;
            }
        } else {
            int i = 0;
            while (i < nBytesRead) {
                byte hibyte;
                byte midbyte;
                byte lobyte;
                if (!bigEndian) {
                    lobyte = byteBuf[i];
                    midbyte = byteBuf[i + 1];
                    hibyte = byteBuf[i + 2];
                } else {
                    lobyte = byteBuf[i + 2];
                    midbyte = byteBuf[i + 1];
                    hibyte = byteBuf[i];
                }
                samples[currentPos] = hibyte << 16 | (midbyte & 0xFF) << 8 | lobyte & 0xFF;
                i += 3;
                ++currentPos;
            }
        }
        return samples;
    }

    public static AudioInputStream downSampling(AudioInputStream ais, int targetSamplingRate) throws Exception {
        float currentSamplingRate = ais.getFormat().getSampleRate();
        if ((float)targetSamplingRate >= currentSamplingRate) {
            throw new Exception("Requested sampling rate " + targetSamplingRate + " is greater than or equal to Audio sampling rate " + currentSamplingRate);
        }
        int noOfbitsPerSample = ais.getFormat().getSampleSizeInBits();
        int channels = ais.getFormat().getChannels();
        ais.available();
        boolean bigEndian = ais.getFormat().isBigEndian();
        double[] samples = new AudioDoubleDataSource(ais).getAllData();
        double filterCutof = 0.5 * (double)targetSamplingRate / (double)currentSamplingRate;
        LowPassFilter filter = new LowPassFilter(filterCutof);
        samples = filter.apply(samples);
        double duration = (double)samples.length / (double)currentSamplingRate;
        int newSampleLen = (int)Math.floor(duration * (double)targetSamplingRate);
        double fraction = (double)currentSamplingRate / (double)targetSamplingRate;
        double[] newSignal = new double[newSampleLen];
        int i = 0;
        while (i < newSignal.length) {
            double posIdx = fraction * (double)i;
            int nVal = (int)Math.floor(posIdx);
            double diffVal = posIdx - (double)nVal;
            newSignal[i] = diffVal * samples[nVal + 1] + (1.0 - diffVal) * samples[nVal];
            ++i;
        }
        boolean signed = true;
        AudioFormat af = new AudioFormat(targetSamplingRate, noOfbitsPerSample, channels, signed, bigEndian);
        DDSAudioInputStream oais = new DDSAudioInputStream(new BufferedDoubleDataSource(newSignal), af);
        return oais;
    }

    public static void removeEndpoints(String inputFile, String outputFile, int energyBufferLength, double speechStartLikelihood, double speechEndLikelihood, double shiftFromMinimumEnergyCenter, int numClusters, double minimumStartSilenceInSeconds, double minimumEndSilenceInSeconds) throws IOException, UnsupportedAudioFileException {
        AudioInputStream ais = AudioSystem.getAudioInputStream(new File(inputFile));
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        int samplingRate = (int)ais.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        int framelength = (int)(0.01 * (double)samplingRate);
        EnergyAnalyser ea = new EnergyAnalyser((DoubleDataSource)signal, framelength, framelength, samplingRate);
        double[][] speechStretches = ea.getSpeechStretchesUsingEnergyHistory(energyBufferLength, speechStartLikelihood, speechEndLikelihood, shiftFromMinimumEnergyCenter, numClusters);
        ais.close();
        try {
            ais = AudioSystem.getAudioInputStream(new File(inputFile));
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        signal = new AudioDoubleDataSource(ais);
        double[] x = signal.getAllData();
        ais.close();
        if (speechStretches.length == 0) {
            System.out.println("No segments detected in " + inputFile + " copying whole file...");
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(x), ais.getFormat());
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outputFile));
        } else {
            int numStretches = speechStretches.length;
            int speechStartIndex = (int)((double)samplingRate * speechStretches[0][0]);
            int speechEndIndex = (int)((double)samplingRate * speechStretches[numStretches - 1][1]);
            int silStartRequired = Math.max(0, (int)((double)samplingRate * minimumStartSilenceInSeconds));
            int silStartLen = 0;
            if (speechStartIndex < silStartRequired) {
                silStartLen = silStartRequired - speechStartIndex;
                speechStartIndex = 0;
            } else {
                speechStartIndex -= silStartRequired;
            }
            double[] silStart = null;
            if (silStartLen > 0) {
                silStart = SignalProcUtils.getWhiteNoise(silStartLen, 1.0E-20);
            }
            int silEndRequired = Math.max(0, (int)((double)samplingRate * minimumEndSilenceInSeconds));
            int silEndLen = 0;
            if (x.length - speechEndIndex < silEndRequired) {
                silEndLen = silEndRequired - (x.length - speechEndIndex);
                speechEndIndex = x.length - 1;
            } else {
                speechEndIndex += silEndRequired;
            }
            double[] silEnd = null;
            if (silEndLen > 0) {
                silEnd = SignalProcUtils.getWhiteNoise(silEndLen, 1.0E-20);
            }
            double[] y = null;
            if (speechEndIndex - speechStartIndex + silStartLen + silEndLen <= 0) {
                throw new Error("No output samples to write for " + inputFile);
            }
            y = new double[speechEndIndex - speechStartIndex + silStartLen + silEndLen];
            int start = 0;
            if (silStartLen > 0) {
                System.arraycopy(silStart, 0, y, start, silStartLen);
                start += silStartLen;
            }
            if (speechEndIndex - speechStartIndex > 0) {
                System.arraycopy(x, speechStartIndex, y, start, speechEndIndex - speechStartIndex);
                start += speechEndIndex - speechStartIndex;
            }
            if (silEndLen > 0) {
                System.arraycopy(silEnd, 0, y, start, silEndLen);
                start += silEndLen;
            }
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(y), ais.getFormat());
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outputFile));
        }
    }

    public static class HighPassFilter
    implements AudioProcessor {
        private double cutoffFrequency;
        private double transitionBandwidth;

        public HighPassFilter(double cutoffFrequency, double transitionBandwidth) {
            this.cutoffFrequency = cutoffFrequency;
            this.transitionBandwidth = transitionBandwidth;
        }

        @Override
        public AudioInputStream apply(AudioInputStream ais) {
            float samplingRate = ais.getFormat().getSampleRate();
            double cutOff = this.cutoffFrequency / (double)samplingRate;
            double transition = this.transitionBandwidth / (double)samplingRate;
            marytts.signalproc.filter.HighPassFilter hFilter = new marytts.signalproc.filter.HighPassFilter(cutOff, transition);
            AudioDoubleDataSource audio = new AudioDoubleDataSource(ais);
            DoubleDataSource filtered = hFilter.apply(audio);
            return new DDSAudioInputStream(filtered, ais.getFormat());
        }
    }

    public static class SequenceAudioProcessor
    implements AudioProcessor {
        private List<AudioProcessor> procs;

        public SequenceAudioProcessor(List<AudioProcessor> procs) {
            this.procs = procs;
        }

        @Override
        public AudioInputStream apply(AudioInputStream ais) {
            AudioInputStream soFar = ais;
            for (AudioProcessor p : this.procs) {
                soFar = p.apply(soFar);
            }
            return soFar;
        }
    }

    public static class Stereo2Mono
    implements AudioProcessor {
        private int mode;

        public Stereo2Mono() {
            this(3);
        }

        public Stereo2Mono(int mode) {
            this.mode = mode;
        }

        @Override
        public AudioInputStream apply(AudioInputStream ais) {
            return new MonoAudioInputStream(ais, this.mode);
        }
    }
}

