/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.PolarFrequencyProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.signal.SignalProcUtils;

public class Robotiser
extends FrameOverlapAddSource {
    public Robotiser(DoubleDataSource inputSource, int samplingRate, float amount) {
        int frameLength = SignalProcUtils.getDFTSize(samplingRate);
        this.initialise(inputSource, 3, true, frameLength, samplingRate, new PhaseRemover(frameLength, amount));
    }

    public Robotiser(DoubleDataSource inputSource, int samplingRate) {
        this(inputSource, samplingRate, 1.0f);
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            Robotiser pv = new Robotiser((DoubleDataSource)signal, samplingRate);
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(pv), inputAudio.getFormat());
            String outFileName = String.valueOf(args[i].substring(0, args[i].length() - 4)) + "_robotised.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }

    public static class PhaseRemover
    extends PolarFrequencyProcessor {
        public PhaseRemover(int fftSize, double amount) {
            super(fftSize, amount);
        }

        public PhaseRemover(int fftSize) {
            this(fftSize, 1.0);
        }

        @Override
        protected void processPolar(double[] r, double[] phi) {
            int i = 0;
            while (i < phi.length) {
                phi[i] = 0.0;
                ++i;
            }
        }
    }
}

