/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;

public class RecursiveFilter {
    protected final double[] a;

    public RecursiveFilter(double[] a) {
        this.a = a;
    }

    public DoubleDataSource apply(DoubleDataSource signal) {
        return new BufferedDoubleDataSource(signal, (InlineDataProcessor)new Processor(this.a));
    }

    public double[] apply(double[] signal) {
        return new BufferedDoubleDataSource(signal, (InlineDataProcessor)new Processor(this.a)).getAllData();
    }

    public static class Processor
    implements InlineDataProcessor {
        protected final double[] a;
        protected final int p;
        protected double[] memory;

        public Processor(double[] a) {
            this.a = a;
            this.p = a.length;
            this.memory = new double[this.p];
        }

        @Override
        public void applyInline(double[] data, int off, int len) {
            if (off < 0 || len <= 0 || off + len > data.length) {
                throw new IllegalArgumentException("off or len out of bounds");
            }
            int n = 0;
            while (n < len) {
                int offn = off + n;
                int i = 1;
                while (i <= this.p) {
                    if (n < i) {
                        int n2 = offn;
                        data[n2] = data[n2] + this.a[i - 1] * this.memory[this.p + n - i];
                    } else {
                        int n3 = offn;
                        data[n3] = data[n3] + this.a[i - 1] * data[offn - i];
                    }
                    ++i;
                }
                ++n;
            }
            if (len < this.p) {
                System.arraycopy(this.memory, len, this.memory, 0, this.p - len);
                System.arraycopy(data, off, this.memory, this.p - len, len);
            } else {
                System.arraycopy(data, off + len - this.p, this.memory, 0, this.p);
            }
        }
    }
}

