/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class SignalSpectrum
extends FunctionGraph {
    public SignalSpectrum(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public SignalSpectrum(AudioInputStream ais, int width, int height) {
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        int samplingRate = (int)ais.getFormat().getSampleRate();
        double[] signal = MaryAudioUtils.getSamplesAsDoubleArray(ais);
        this.initialise(signal, samplingRate, width, height);
    }

    public SignalSpectrum(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public SignalSpectrum(double[] signal, int samplingRate, int width, int height) {
        this.initialise(signal, samplingRate, width, height);
    }

    protected void initialise(double[] signal, int samplingRate, int width, int height) {
        int N = signal.length;
        if (!MathUtils.isPowerOfTwo(N)) {
            N = MathUtils.closestPowerOfTwoAbove(N);
        }
        double[] ar = new double[N];
        System.arraycopy(signal, 0, ar, 0, signal.length);
        FFT.realTransform(ar, false);
        double[] freqs = FFT.computeAmplitudeSpectrum_FD(ar);
        this.process(freqs);
        double deltaF = (double)samplingRate / (double)N;
        super.initialise(width, height, 0.0, deltaF, freqs);
    }

    protected void process(double[] freqs) {
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            SignalSpectrum signalSpectrum = new SignalSpectrum(ais);
            signalSpectrum.showInJFrame(args[i], true, false);
            ++i;
        }
    }
}

