/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.string.PrintfFormat;

public class AudioFileDuration {
    public static void main(String[] args) throws Exception {
        PrintfFormat format = new PrintfFormat("%.4f");
        int file = 0;
        while (file < args.length) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[file]));
            if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
            }
            float samplingRate = ais.getFormat().getSampleRate();
            double[] signal = new AudioDoubleDataSource(ais).getAllData();
            float duration = (float)signal.length / samplingRate;
            System.out.println(String.valueOf(args[file]) + ": " + format.sprintf((double)duration) + " s");
            ++file;
        }
    }
}

