/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import marytts.exceptions.MaryConfigurationException;
import marytts.server.MaryProperties;
import marytts.unitselection.data.DiphoneUnit;
import marytts.unitselection.data.SCostFileReader;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.StatisticalCostFunction;
import marytts.util.data.MaryHeader;

public class StatisticalModelCost
implements StatisticalCostFunction {
    protected SCostFileReader sCostReader;
    protected float sCostWeight;
    private MaryHeader hdr = null;

    @Override
    public void init(String configPrefix) throws MaryConfigurationException {
        try {
            String sCostFileName = MaryProperties.needFilename(String.valueOf(configPrefix) + ".sCostFile");
            this.sCostWeight = Float.parseFloat(MaryProperties.getProperty(String.valueOf(configPrefix) + ".sCostWeight", "1.0"));
            this.sCostReader = new SCostFileReader(sCostFileName);
        }
        catch (Exception e) {
            throw new MaryConfigurationException("Cannot initialise scost model", (Throwable)e);
        }
    }

    public int getNumberOfUnits() {
        return this.sCostReader.getNumberOfUnits();
    }

    @Override
    public double cost(Unit u1, Unit u2) {
        if (u1.duration == 0 || u2.duration == 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u1 instanceof DiphoneUnit) {
            u1 = ((DiphoneUnit)u1).right;
        }
        if (u2 instanceof DiphoneUnit) {
            u2 = ((DiphoneUnit)u2).left;
        }
        double sCost1 = this.sCostReader.getSCost(u1.index);
        double sCost2 = this.sCostReader.getSCost(u2.index);
        return (sCost1 + sCost2) / 2.0;
    }

    public double cost(Unit u1, Unit u2, boolean consecutive) {
        if (u1.duration == 0 || u2.duration == 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u1 instanceof DiphoneUnit) {
            u1 = ((DiphoneUnit)u1).right;
        }
        if (u2 instanceof DiphoneUnit) {
            u2 = ((DiphoneUnit)u2).left;
        }
        if (consecutive && u1.index + 1 == u2.index) {
            return 0.0;
        }
        double sCost1 = this.sCostReader.getSCost(u1.index);
        double sCost2 = this.sCostReader.getSCost(u2.index);
        return (sCost1 + sCost2) / 2.0;
    }
}

