/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import marytts.features.FeatureVector;
import marytts.unitselection.data.DiphoneUnit;
import marytts.unitselection.data.Unit;
import marytts.unitselection.data.UnitDatabase;
import marytts.unitselection.select.DiphoneTarget;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.viterbi.ViterbiCandidate;
import marytts.util.MaryUtils;
import marytts.util.dom.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiphoneUnitDatabase
extends UnitDatabase {
    public DiphoneUnitDatabase() {
        this.logger = MaryUtils.getLogger((String)"DiphoneUnitDatabase");
    }

    @Override
    public List<ViterbiCandidate> getCandidates(Target target) {
        byte bunitName;
        FeatureVector fv;
        Unit unit;
        if (!(target instanceof DiphoneTarget)) {
            return super.getCandidates(target);
        }
        DiphoneTarget diphoneTarget = (DiphoneTarget)target;
        HalfPhoneTarget left = diphoneTarget.left;
        HalfPhoneTarget right = diphoneTarget.right;
        String blacklist = "";
        String unitBasename = "This must never be null or the empty string!";
        Element targetElement = left.getMaryxmlElement();
        if (targetElement == null) {
            targetElement = right.getMaryxmlElement();
        }
        blacklist = DomUtils.getAttributeFromClosestAncestorOfAnyKind((Node)targetElement, (String)"blacklist");
        String leftName = left.getName().substring(0, left.getName().lastIndexOf("_"));
        String rightName = right.getName().substring(0, right.getName().lastIndexOf("_"));
        int iPhoneme = this.targetCostFunction.getFeatureDefinition().getFeatureIndex("phone");
        byte bleftName = this.targetCostFunction.getFeatureDefinition().getFeatureValueAsByte(iPhoneme, leftName);
        byte brightName = this.targetCostFunction.getFeatureDefinition().getFeatureValueAsByte(iPhoneme, rightName);
        FeatureVector[] fvs = this.targetCostFunction.getFeatureVectors();
        TIntHashSet candidateUnitSet = new TIntHashSet();
        int[] clist = (int[])this.preselectionCART.interpret(left, this.backtrace);
        this.logger.debug((Object)("For target " + target + ", selected " + clist.length + " units"));
        int i = 0;
        while (i < clist.length) {
            int iRightNeighbour;
            unit = this.unitReader.units[clist[i]];
            fv = fvs != null ? fvs[unit.index] : this.targetCostFunction.getFeatureVector(unit);
            bunitName = fv.byteValuedDiscreteFeatures[iPhoneme];
            if (bunitName == bleftName && (iRightNeighbour = clist[i] + 1) < this.numUnits) {
                Unit rightNeighbour = this.unitReader.units[iRightNeighbour];
                FeatureVector rfv = fvs != null ? fvs[iRightNeighbour] : this.targetCostFunction.getFeatureVector(rightNeighbour);
                byte brightUnitName = rfv.byteValuedDiscreteFeatures[iPhoneme];
                if (brightUnitName == brightName) {
                    candidateUnitSet.add(unit.index);
                }
            }
            ++i;
        }
        clist = (int[])this.preselectionCART.interpret(right, this.backtrace);
        this.logger.debug((Object)("For target " + target + ", selected " + clist.length + " units"));
        i = 0;
        while (i < clist.length) {
            int iLeftNeighbour;
            unit = this.unitReader.units[clist[i]];
            fv = fvs != null ? fvs[unit.index] : this.targetCostFunction.getFeatureVector(unit);
            bunitName = fv.byteValuedDiscreteFeatures[iPhoneme];
            if (bunitName == brightName && (iLeftNeighbour = clist[i] - 1) >= 0) {
                Unit leftNeighbour = this.unitReader.units[iLeftNeighbour];
                FeatureVector lfv = fvs != null ? fvs[iLeftNeighbour] : this.targetCostFunction.getFeatureVector(leftNeighbour);
                byte bleftUnitName = lfv.byteValuedDiscreteFeatures[iPhoneme];
                if (bleftUnitName == bleftName) {
                    candidateUnitSet.add(leftNeighbour.index);
                }
            }
            ++i;
        }
        ArrayList<ViterbiCandidate> candidates = new ArrayList<ViterbiCandidate>(candidateUnitSet.size());
        int[] nArray = candidateUnitSet.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int leftIndex = nArray[n2];
            DiphoneUnit diphoneUnit = new DiphoneUnit(this.unitReader.units[leftIndex], this.unitReader.units[leftIndex + 1]);
            ViterbiCandidate candidate = new ViterbiCandidate(diphoneTarget, diphoneUnit, this.targetCostFunction);
            if (blacklist.equals("")) {
                candidates.add(candidate);
            } else {
                unitBasename = this.getFilename(diphoneUnit);
                if (!blacklist.contains(unitBasename)) {
                    candidates.add(candidate);
                }
            }
            ++n2;
        }
        this.logger.debug((Object)("Preselected " + candidateUnitSet.size() + " diphone candidates for target " + target));
        return candidates;
    }
}

