/*
 * Decompiled with CFR 0.152.
 */
package marytts.features;

import java.io.InputStream;
import java.util.Map;
import marytts.features.ByteValuedFeatureProcessor;
import marytts.features.MaryGenericFeatureProcessors;
import marytts.fst.FSTLookup;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.Target;
import marytts.util.dom.MaryDomUtils;
import marytts.util.string.ByteStringTranslator;
import org.w3c.dom.Element;

public class MaryLanguageFeatureProcessors
extends MaryGenericFeatureProcessors {
    private MaryLanguageFeatureProcessors() {
    }

    public static class Gpos
    implements ByteValuedFeatureProcessor {
        private Map<String, String> posConverter;
        private ByteStringTranslator values;
        private MaryGenericFeatureProcessors.TargetElementNavigator navigator;

        @Override
        public String getName() {
            return "gpos";
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        public Gpos(Map<String, String> posConverter) {
            this.posConverter = posConverter;
            this.values = new ByteStringTranslator(new String[]{"0", "in", "to", "det", "md", "cc", "wp", "pps", "aux", "punc", "content"});
            this.navigator = new MaryGenericFeatureProcessors.WordNavigator();
        }

        @Override
        public byte process(Target target) {
            Element word = this.navigator.getElement(target);
            if (word == null) {
                return this.values.get("0");
            }
            String pos = word.getAttribute("pos");
            if (pos == null) {
                return this.values.get("0");
            }
            if (this.posConverter.containsKey(pos = pos.trim())) {
                pos = this.posConverter.get(pos);
            }
            if (!this.values.contains(pos)) {
                return this.values.get("0");
            }
            return this.values.get(pos);
        }
    }

    public static class HalfPhoneUnitName
    implements ByteValuedFeatureProcessor {
        protected String name = "halfphone_unitname";
        protected ByteStringTranslator values;
        protected String pauseSymbol;

        public HalfPhoneUnitName(String[] possiblePhonemes, String pauseSymbol) {
            this.pauseSymbol = pauseSymbol;
            String[] possibleValues = new String[2 * possiblePhonemes.length + 1];
            possibleValues[0] = "0";
            int i = 0;
            while (i < possiblePhonemes.length) {
                possibleValues[2 * i + 1] = String.valueOf(possiblePhonemes[i]) + "_L";
                possibleValues[2 * i + 2] = String.valueOf(possiblePhonemes[i]) + "_R";
                ++i;
            }
            this.values = new ByteStringTranslator(possibleValues);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            if (!(target instanceof HalfPhoneTarget)) {
                return 0;
            }
            HalfPhoneTarget hpTarget = (HalfPhoneTarget)target;
            Element segment = target.getMaryxmlElement();
            String phoneLabel = segment == null ? this.pauseSymbol : (!segment.getTagName().equals("ph") ? this.pauseSymbol : segment.getAttribute("p"));
            if (phoneLabel.equals("")) {
                return this.values.get("0");
            }
            String unitLabel = String.valueOf(phoneLabel) + (hpTarget.isLeftHalf() ? "_L" : "_R");
            return this.values.get(unitLabel);
        }
    }

    public static class Phone
    implements ByteValuedFeatureProcessor {
        protected String name;
        protected ByteStringTranslator values;
        protected String pauseSymbol;
        protected MaryGenericFeatureProcessors.TargetElementNavigator navigator;

        public Phone(String name, String[] possibleValues, String pauseSymbol, MaryGenericFeatureProcessors.TargetElementNavigator segmentNavigator) {
            this.name = name;
            this.values = new ByteStringTranslator(possibleValues);
            this.pauseSymbol = pauseSymbol;
            this.navigator = segmentNavigator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element segment = this.navigator.getElement(target);
            if (segment == null) {
                return this.values.get(this.pauseSymbol);
            }
            if (!segment.getTagName().equals("ph")) {
                return this.values.get(this.pauseSymbol);
            }
            String ph = segment.getAttribute("p");
            if (!this.values.contains(ph)) {
                return this.values.get("0");
            }
            return this.values.get(ph);
        }

        public String getPauseSymbol() {
            return this.pauseSymbol;
        }
    }

    public static class PhoneFeature
    implements ByteValuedFeatureProcessor {
        protected AllophoneSet phoneSet;
        protected String name;
        protected String phonesetQuery;
        protected ByteStringTranslator values;
        protected String pauseSymbol;
        protected MaryGenericFeatureProcessors.TargetElementNavigator navigator;

        public PhoneFeature(AllophoneSet phoneSet, String name, String phonesetQuery, String[] possibleValues, String pauseSymbol, MaryGenericFeatureProcessors.TargetElementNavigator segmentNavigator) {
            this.phoneSet = phoneSet;
            this.name = name;
            this.phonesetQuery = phonesetQuery;
            this.values = new ByteStringTranslator(possibleValues);
            this.navigator = segmentNavigator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element segment = this.navigator.getElement(target);
            if (segment == null) {
                return this.values.get("0");
            }
            String ph = !segment.getTagName().equals("ph") ? this.pauseSymbol : segment.getAttribute("p");
            String value = this.phoneSet.getPhoneFeature(ph, this.phonesetQuery);
            if (value == null) {
                return this.values.get("0");
            }
            return this.values.get(value);
        }
    }

    public static class Pos
    implements ByteValuedFeatureProcessor {
        private ByteStringTranslator values;
        private MaryGenericFeatureProcessors.TargetElementNavigator navigator;
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        public Pos(String[] posValues) {
            this.values = new ByteStringTranslator(posValues);
            this.navigator = new MaryGenericFeatureProcessors.WordNavigator();
            this.name = "pos";
        }

        public Pos(String aName, String[] posValues, MaryGenericFeatureProcessors.TargetElementNavigator wordNavi) {
            this.values = new ByteStringTranslator(posValues);
            this.navigator = wordNavi;
            this.name = aName;
        }

        @Override
        public byte process(Target target) {
            Element word = this.navigator.getElement(target);
            if (word == null) {
                return this.values.get("0");
            }
            String pos = word.getAttribute("pos");
            if (pos == null) {
                return this.values.get("0");
            }
            if (this.values.contains(pos = pos.trim())) {
                return this.values.get(pos);
            }
            return this.values.get("0");
        }
    }

    public static class SegOnsetCoda
    implements ByteValuedFeatureProcessor {
        protected ByteStringTranslator values;
        private AllophoneSet phoneSet;

        public SegOnsetCoda(AllophoneSet phoneSet) {
            this.phoneSet = phoneSet;
            this.values = new ByteStringTranslator(new String[]{"0", "onset", "coda"});
        }

        @Override
        public String getName() {
            return "onsetcoda";
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public byte process(Target target) {
            s = target.getMaryxmlElement();
            if (s == null) {
                return 0;
            }
            if (s.getTagName().equals("ph")) ** GOTO lbl9
            return 0;
lbl-1000:
            // 1 sources

            {
                ph = s.getAttribute("p");
                if (!"+".equals(this.phoneSet.getPhoneFeature(ph, "vc"))) continue;
                return this.values.get("onset");
lbl9:
                // 2 sources

                ** while ((s = MaryDomUtils.getNextSiblingElement((Element)s)) != null)
            }
lbl10:
            // 1 sources

            return this.values.get("coda");
        }
    }

    public static class Selection_PhoneClass
    implements ByteValuedFeatureProcessor {
        protected String name = "selection_next_phone_class";
        protected Map<String, String> phones2Classes;
        protected ByteStringTranslator values;
        protected MaryGenericFeatureProcessors.TargetElementNavigator navigator;

        public Selection_PhoneClass(Map<String, String> phones2Classes, String[] classes, MaryGenericFeatureProcessors.TargetElementNavigator segmentNavigator) {
            this.phones2Classes = phones2Classes;
            this.values = new ByteStringTranslator(classes);
            this.navigator = segmentNavigator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            Element segment = this.navigator.getElement(target);
            if (segment == null) {
                return this.values.get("0");
            }
            if (!segment.getTagName().equals("ph")) {
                return 0;
            }
            String ph = segment.getAttribute("p");
            String phoneClass = this.phones2Classes.get(ph);
            if (phoneClass == null) {
                return this.values.get("0");
            }
            return this.values.get(phoneClass);
        }
    }

    public static class WordFrequency
    implements ByteValuedFeatureProcessor {
        protected MaryGenericFeatureProcessors.TargetElementNavigator navigator = new MaryGenericFeatureProcessors.WordNavigator();
        protected ByteStringTranslator values;
        protected FSTLookup wordFrequencies;

        public WordFrequency(InputStream inStream, String identifier, String encoding) {
            try {
                this.wordFrequencies = inStream != null ? new FSTLookup(inStream, identifier, encoding) : null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.values = new ByteStringTranslator(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
        }

        @Override
        public String getName() {
            return "word_frequency";
        }

        @Override
        public String[] getValues() {
            return this.values.getStringValues();
        }

        @Override
        public byte process(Target target) {
            String freq;
            String[] result;
            Element word = this.navigator.getElement(target);
            if (word == null) {
                return 0;
            }
            String wordString = MaryDomUtils.tokenText(word);
            if (this.wordFrequencies != null && (result = this.wordFrequencies.lookup(wordString)).length > 0 && this.values.contains(freq = result[0])) {
                return this.values.get(freq);
            }
            return 0;
        }
    }
}

