/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.io;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import marytts.cart.CART;
import marytts.cart.DecisionNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.features.FeatureVector;
import marytts.util.data.MaryHeader;

public class WagonCARTWriter {
    public void dumpWagonCART(CART cart, String destFile) throws IOException {
        System.out.println("Dumping CART to " + destFile + " ...");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(destFile)));
        MaryHeader hdr = new MaryHeader(100);
        hdr.writeTo((DataOutput)out);
        out.writeInt(cart.getNumNodes());
        String name = "";
        out.writeUTF(name);
        this.dumpBinary(cart, out);
        out.close();
        System.out.println(" ... done\n");
    }

    public void toTextOut(CART cart, PrintWriter pw) throws IOException {
        try {
            this.toWagonFormat(cart.getRootNode(), null, "", pw);
            pw.flush();
            pw.close();
        }
        catch (IOException ioe) {
            IOException newIOE = new IOException("Error dumping CART to standard output");
            newIOE.initCause(ioe);
            throw newIOE;
        }
    }

    public void dumpBinary(CART cart, DataOutput os) throws IOException {
        try {
            this.toWagonFormat(cart.getRootNode(), (DataOutputStream)os, null, null);
        }
        catch (IOException ioe) {
            IOException newIOE = new IOException("Error dumping CART to output stream");
            newIOE.initCause(ioe);
            throw newIOE;
        }
    }

    private void toWagonFormat(Node node, DataOutputStream out, String extension, PrintWriter pw) throws IOException {
        if (node instanceof DecisionNode) {
            this.toWagonFormat((DecisionNode)node, out, extension, pw);
        } else if (node instanceof LeafNode.FeatureVectorLeafNode) {
            this.toWagonFormat((LeafNode.FeatureVectorLeafNode)node, out, extension, pw);
        } else if (node instanceof LeafNode.FloatLeafNode) {
            this.toWagonFormat((LeafNode.FloatLeafNode)node, out, extension, pw);
        } else if (node instanceof LeafNode.IntAndFloatArrayLeafNode) {
            this.toWagonFormat((LeafNode.IntAndFloatArrayLeafNode)node, out, extension, pw);
        } else if (node instanceof LeafNode.IntArrayLeafNode) {
            this.toWagonFormat((LeafNode.IntArrayLeafNode)node, out, extension, pw);
        }
    }

    private void toWagonFormat(DecisionNode node, DataOutputStream out, String extension, PrintWriter pw) throws IOException {
        if (out != null) {
            WagonCARTWriter.writeStringToOutput("((" + node.getNodeDefinition() + ")", out);
        }
        if (pw != null) {
            pw.println("((" + node.getNodeDefinition() + ")");
        }
        int i = 0;
        while (i < node.getNumberOfDaugthers()) {
            if (node.getDaughter(i) == null) {
                String nullDaughter = "";
                nullDaughter = i + 1 != node.getNumberOfDaugthers() ? "((() 0))" : (extension != null ? "((() 0)))" + extension : "((() 0)))");
                if (out != null) {
                    WagonCARTWriter.writeStringToOutput(nullDaughter, out);
                }
                if (pw != null) {
                    pw.println(" " + nullDaughter);
                }
            } else if (i + 1 != node.getNumberOfDaugthers()) {
                this.toWagonFormat(node.getDaughter(i), out, "", pw);
            } else if (extension != null) {
                this.toWagonFormat(node.getDaughter(i), out, ")" + extension, pw);
            } else {
                this.toWagonFormat(node.getDaughter(i), out, ")", pw);
            }
            ++i;
        }
    }

    private void toWagonFormat(LeafNode.FeatureVectorLeafNode node, DataOutputStream out, String extension, PrintWriter pw) throws IOException {
        StringBuilder sb = new StringBuilder();
        FeatureVector[] fv = node.getFeatureVectors();
        sb.append("(((");
        int i = 0;
        while (i < fv.length) {
            sb.append("(" + fv[i].getUnitIndex() + " 0)");
            if (i + 1 != fv.length) {
                sb.append(" ");
            }
            ++i;
        }
        sb.append(") 0))" + extension);
        if (out != null) {
            WagonCARTWriter.writeStringToOutput(sb.toString(), out);
        }
        if (pw != null) {
            pw.println(sb.toString());
        }
    }

    private void toWagonFormat(LeafNode.FloatLeafNode node, DataOutputStream out, String extension, PrintWriter pw) throws IOException {
        String s = "((" + node.getStDeviation() + " " + node.getMean() + "))";
        if (out != null) {
            WagonCARTWriter.writeStringToOutput(s, out);
        }
        if (pw != null) {
            pw.println(s);
        }
    }

    private void toWagonFormat(LeafNode.IntAndFloatArrayLeafNode node, DataOutputStream out, String extension, PrintWriter pw) throws IOException {
        StringBuilder sb = new StringBuilder();
        int[] data = node.getIntData();
        float[] floats = node.getFloatData();
        sb.append("(((");
        int i = 0;
        while (i < data.length) {
            sb.append("(" + data[i] + " " + floats[i] + ")");
            if (i + 1 != data.length) {
                sb.append(" ");
            }
            ++i;
        }
        sb.append(") 0))" + extension);
        if (out != null) {
            WagonCARTWriter.writeStringToOutput(sb.toString(), out);
        }
        if (pw != null) {
            pw.println(sb.toString());
        }
    }

    private void toWagonFormat(LeafNode.IntArrayLeafNode node, DataOutputStream out, String extension, PrintWriter pw) throws IOException {
        StringBuilder sb = new StringBuilder();
        int[] data = node.getIntData();
        sb.append("(((");
        int i = 0;
        while (i < data.length) {
            sb.append("(" + data[i] + " 0)");
            if (i + 1 != data.length) {
                sb.append(" ");
            }
            ++i;
        }
        sb.append(") 0))" + extension);
        if (out != null) {
            WagonCARTWriter.writeStringToOutput(sb.toString(), out);
        }
        if (pw != null) {
            pw.println(sb.toString());
        }
    }

    private static void writeStringToOutput(String str, DataOutput out) throws IOException {
        out.writeInt(str.length());
        out.writeChars(str);
    }
}

