/*
 * Decompiled with CFR 0.152.
 */
package de.xab.porter.transfer.jdbc.writer;

import de.xab.porter.api.Column;
import de.xab.porter.api.Relation;
import de.xab.porter.api.Result;
import de.xab.porter.api.dataconnection.SinkConnection;
import de.xab.porter.api.exception.PorterException;
import de.xab.porter.common.util.Loggers;
import de.xab.porter.common.util.Strings;
import de.xab.porter.transfer.jdbc.writer.JDBCWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class PostgreSQLWriter
extends JDBCWriter {
    private final Logger logger = Loggers.getLogger(this.getClass());

    @Override
    protected void writeInDefaultMode(Result<?> data) {
        this.writeInPostgreSQLFileMode(data);
    }

    protected void writeInPostgreSQLFileMode(Result<?> data) {
        SinkConnection sinkConnection = (SinkConnection)this.getConnector().getDataConnection();
        SinkConnection.Environments environments = sinkConnection.getEnvironments();
        Relation relation = (Relation)data.getResult();
        StringReader stringReader = null;
        String columns = relation.getMeta().stream().map(col -> this.getColumnIdentifier(col.getName(), environments.getQuote())).collect(Collectors.joining(", "));
        String tableIdentifier = environments.getTableIdentifier();
        String copySQL = String.format("COPY %s (%s) FROM STDIN WITH DELIMITER '|'", tableIdentifier, columns);
        try {
            BaseConnection pgConnection = ((Connection)this.connection).unwrap(BaseConnection.class);
            CopyManager copyManager = new CopyManager(pgConnection);
            String csv = relation.getData().stream().map(row -> row.stream().map(Object::toString).collect(Collectors.joining("|"))).collect(Collectors.joining("\n"));
            stringReader = new StringReader(csv);
            long rowCount = copyManager.copyIn(copySQL, (Reader)new BufferedReader(stringReader));
            this.logger.info(String.format("wrote %d rows to table %s", rowCount, tableIdentifier));
        }
        catch (IOException | SQLException e) {
            this.logger.severe(String.format("copy data failed.\n%s", copySQL));
            throw new PorterException("copy data failed", (Throwable)e);
        }
        finally {
            if (stringReader != null) {
                stringReader.close();
            }
        }
    }

    @Override
    protected String getCreate(String tableIdentifier) {
        return String.format("CREATE TABLE IF NOT EXISTS %s (\n", tableIdentifier);
    }

    @Override
    protected String getColumns(List<Column> meta, String quote) {
        return meta.stream().map(column -> "\t" + this.getColumnIdentifier(column.getName(), quote) + "\t" + this.getColumnType((Column)column) + "\t" + (Strings.notNullOrBlank((String)column.getNullable()) && "NO".equals(column.getNullable()) ? "NOT NULL" : "NULL")).collect(Collectors.joining(", \n"));
    }

    @Override
    protected String getAfterDDL(Map<Short, String> primaryKeyMap, String tableIdentifier, String quote, List<Column> meta) {
        return meta.stream().map(column -> Strings.notNullOrBlank((String)column.getComment()) ? ";\nCOMMENT ON COLUMN " + tableIdentifier + "." + quote + column.getName() + quote + " IS '" + column.getComment() + "'" : "").collect(Collectors.joining()) + ";";
    }

    protected String getTableIdentifier() {
        SinkConnection sinkConnection = (SinkConnection)this.getConnector().getDataConnection();
        String quote = sinkConnection.getEnvironments().getQuote();
        return quote + sinkConnection.getCatalog() + quote + "." + quote + sinkConnection.getSchema() + quote + "." + quote + sinkConnection.getTable() + quote;
    }

    @Override
    protected String getColumnType(Column column) {
        switch (column.getColumnType()) {
            case INTEGER: 
            case TIMESTAMP: {
                return column.getColumnType().getName();
            }
        }
        return super.getColumnType(column);
    }
}

