/*
 * Decompiled with CFR 0.152.
 */
package de.xab.porter.transfer.jdbc.writer;

import de.xab.porter.api.Column;
import de.xab.porter.api.Relation;
import de.xab.porter.api.Result;
import de.xab.porter.api.dataconnection.DataConnection;
import de.xab.porter.api.dataconnection.SinkConnection;
import de.xab.porter.api.exception.PorterException;
import de.xab.porter.common.util.Jsons;
import de.xab.porter.common.util.Loggers;
import de.xab.porter.common.util.Strings;
import de.xab.porter.transfer.exception.ConnectionException;
import de.xab.porter.transfer.jdbc.connector.JDBCConnector;
import de.xab.porter.transfer.writer.AbstractWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class JDBCWriter
extends AbstractWriter<Connection>
implements JDBCConnector {
    private final Logger logger = Loggers.getLogger(this.getClass());

    public void createTable(Result<?> data) {
        SinkConnection sinkConnection = (SinkConnection)this.getConnector().getDataConnection();
        SinkConnection.Environments environments = sinkConnection.getEnvironments();
        String tableIdentifier = this.getTableIdentifier();
        String quote = environments.getQuote();
        List meta = ((Relation)data.getResult()).getMeta();
        this.logger.fine(String.format("meta of table %s is: \n%s", tableIdentifier, Jsons.toJson((Object)meta)));
        String ddl = this.getCreateDDL(tableIdentifier, quote, meta);
        this.logger.info(String.format("create table %s: \n%s", tableIdentifier, ddl));
        try (Statement stmt = ((Connection)this.connection).createStatement();){
            stmt.executeUpdate(ddl);
        }
        catch (SQLException e) {
            this.logger.info(String.format("table %s create failed", tableIdentifier));
            throw new PorterException("create table failed", (Throwable)e);
        }
    }

    protected void doWrite(Result<?> data) {
        Relation relation = (Relation)data.getResult();
        SinkConnection.Properties properties = ((SinkConnection)this.getConnector().getDataConnection()).getProperties();
        switch (properties.getWriteMode()) {
            case "PREPARED_BATCH": {
                this.writeInPrepareBatchMode(relation);
                break;
            }
            case "STATEMENT_BATCH": {
                this.writeInStatementBatchMode(relation);
                break;
            }
            case "STATEMENT_VALUES": {
                this.writeInValueMode(relation);
                break;
            }
            default: {
                this.writeInDefaultMode(data);
            }
        }
    }

    protected void writeInValueMode(Relation relation) {
        SinkConnection sinkConnection = (SinkConnection)this.getConnector().getDataConnection();
        SinkConnection.Environments environments = sinkConnection.getEnvironments();
        String tableIdentifier = environments.getTableIdentifier();
        StringBuilder sqlBuilder = new StringBuilder(String.format("INSERT INTO %s \n", tableIdentifier));
        sqlBuilder.append("(").append(relation.getMeta().stream().map(column -> this.getColumnIdentifier(column.getName(), environments.getQuote())).collect(Collectors.joining(", "))).append(")");
        sqlBuilder.append("VALUES\n");
        sqlBuilder.append(relation.getData().stream().map(row -> "(" + row.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")").collect(Collectors.joining(", \n")));
        try (Statement stmt = ((Connection)this.connection).createStatement();){
            int rowCount = stmt.executeUpdate(sqlBuilder.toString());
            this.logger.info(String.format("wrote %d rows to table %s", rowCount, tableIdentifier));
        }
        catch (SQLException e) {
            this.logger.severe(sqlBuilder.toString());
            throw new PorterException("write data failed", (Throwable)e);
        }
    }

    protected void writeInStatementBatchMode(Relation relation) {
        SinkConnection sinkConnection = (SinkConnection)this.getConnector().getDataConnection();
        SinkConnection.Environments environments = sinkConnection.getEnvironments();
        String tableIdentifier = environments.getTableIdentifier();
        StringBuilder sqlBuilder = new StringBuilder(String.format("INSERT INTO %s ", tableIdentifier));
        sqlBuilder.append("(").append(relation.getMeta().stream().map(column -> this.getColumnIdentifier(column.getName(), environments.getQuote())).collect(Collectors.joining(", "))).append(")");
        String prefix = sqlBuilder.append("VALUES(").toString();
        try (Statement statement = ((Connection)this.connection).createStatement();){
            for (List row : relation.getData()) {
                String insert = prefix + row.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")";
                statement.addBatch(insert);
            }
            int[] result = statement.executeBatch();
            long rowCount = Arrays.stream(result).summaryStatistics().getSum();
            this.logger.info(String.format("wrote %d rows to table %s", rowCount, tableIdentifier));
        }
        catch (SQLException e) {
            throw new PorterException("write data failed", (Throwable)e);
        }
    }

    protected void writeInPrepareBatchMode(Relation relation) {
        SinkConnection sinkConnection = (SinkConnection)this.getConnector().getDataConnection();
        SinkConnection.Environments environments = sinkConnection.getEnvironments();
        String tableIdentifier = environments.getTableIdentifier();
        StringBuilder sqlBuilder = new StringBuilder(String.format("INSERT INTO %s \n", tableIdentifier));
        sqlBuilder.append("(").append(relation.getMeta().stream().map(column -> this.getColumnIdentifier(column.getName(), environments.getQuote())).collect(Collectors.joining(", "))).append(")\n");
        sqlBuilder.append("VALUES\n");
        sqlBuilder.append("(").append(relation.getMeta().stream().map(row -> "?").collect(Collectors.joining(", "))).append(")");
        try (PreparedStatement statement = ((Connection)this.connection).prepareStatement(sqlBuilder.toString());){
            for (List row2 : relation.getData()) {
                for (int i = 0; i < row2.size(); ++i) {
                    statement.setObject(i + 1, row2.get(i), ((Column)relation.getMeta().get(i)).getColumnType().getVendorTypeNumber());
                }
                statement.addBatch();
            }
            int[] result = statement.executeBatch();
            long rowCount = Arrays.stream(result).summaryStatistics().getSum();
            this.logger.info(String.format("wrote %d rows to table %s", rowCount, tableIdentifier));
        }
        catch (SQLException e) {
            throw new PorterException("write data failed", (Throwable)e);
        }
    }

    protected void writeInDefaultMode(Result<?> data) {
        this.writeInValueMode((Relation)data.getResult());
    }

    public String getIdentifierQuote() {
        try {
            return ((Connection)this.connection).getMetaData().getIdentifierQuoteString();
        }
        catch (SQLException e) {
            throw new PorterException("read quote from JDBC meta data failed", (Throwable)e);
        }
    }

    protected String getCreateDDL(String tableIdentifier, String quote, List<Column> meta) {
        Map<Short, String> primaryKeyMap = this.sortPrimaryKey(meta, quote);
        return this.getCreate(tableIdentifier) + this.getColumns(meta, quote) + this.getConstraints(primaryKeyMap) + this.getAfterDDL(primaryKeyMap, tableIdentifier, quote, meta);
    }

    protected String getCreate(String tableIdentifier) {
        return String.format("CREATE TABLE IF NOT EXISTS %s (\n", tableIdentifier);
    }

    protected String getColumns(List<Column> meta, String quote) {
        return meta.stream().map(column -> "\t" + this.getColumnIdentifier(column.getName(), quote) + "\t" + this.getColumnType((Column)column) + "\t" + (Strings.notNullOrBlank((String)column.getNullable()) && "NO".equals(column.getNullable()) ? "NOT NULL" : "NULL") + (String)(Strings.notNullOrBlank((String)column.getComment()) ? "\tCOMMENT\t'" + column.getComment() + "'" : "")).collect(Collectors.joining(", \n"));
    }

    protected String getConstraints(Map<Short, String> primaryKeyMap) {
        if (primaryKeyMap != null && !primaryKeyMap.isEmpty()) {
            return ",\n\tPRIMARY KEY (" + String.join((CharSequence)", ", primaryKeyMap.values()) + ")\n)";
        }
        return "\n)";
    }

    protected String getAfterDDL(Map<Short, String> primaryKeyMap, String tableIdentifier, String quote, List<Column> meta) {
        return "";
    }

    protected Map<Short, String> sortPrimaryKey(List<Column> meta, String quote) {
        TreeMap<Short, String> primaryKeyMap = new TreeMap<Short, String>();
        meta.forEach(column -> {
            short primaryKeySeq = column.getPrimaryKeySeq();
            if (column.isPrimaryKey() && primaryKeySeq != 0) {
                primaryKeyMap.put(primaryKeySeq, this.getColumnIdentifier(column.getName(), quote));
            }
        });
        return primaryKeyMap;
    }

    protected String getColumnType(Column column) {
        String columnTypeName = column.getColumnTypeName();
        switch (column.getColumnType()) {
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: 
            case ARRAY: 
            case NCHAR: 
            case NVARCHAR: 
            case LONGNVARCHAR: {
                return columnTypeName + "(" + column.getPrecision() + ")";
            }
            case FLOAT: 
            case REAL: 
            case DOUBLE: 
            case NUMERIC: 
            case DECIMAL: {
                return columnTypeName + "(" + column.getPrecision() + ", " + column.getScale() + ")";
            }
        }
        return columnTypeName;
    }

    public Connection connect(DataConnection dataConnection) throws ConnectionException {
        SinkConnection sinkConnection = (SinkConnection)dataConnection;
        this.connection = (Connection)this.getConnector().connect(new Object[]{sinkConnection, this.getJDBCUrl((DataConnection)sinkConnection)});
        return (Connection)this.connection;
    }
}

