/*
 * Decompiled with CFR 0.152.
 */
package de.xab.porter.transfer.jdbc.connector;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import de.xab.porter.api.dataconnection.DataConnection;
import de.xab.porter.api.exception.PorterException;
import de.xab.porter.common.util.Loggers;
import de.xab.porter.transfer.connector.Connector;
import de.xab.porter.transfer.exception.ConnectionException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public class HikariConnector
implements Connector<Connection> {
    private final Logger logger = Loggers.getLogger((String)"HIKARI");
    private DataConnection dataConnection;
    private HikariDataSource hikariDataSource;
    private Connection connection;

    public Connection connect(Object ... args) throws ConnectionException {
        this.dataConnection = (DataConnection)args[0];
        String jdbcUrl = (String)args[1];
        try {
            this.logger.info(String.format("connecting to %s %s...", this.dataConnection.getType(), this.dataConnection.getUrl()));
            this.hikariDataSource = this.genDataSource(this.dataConnection, jdbcUrl);
            this.connection = this.hikariDataSource.getConnection();
            this.logger.info(String.format("connected to %s %s...", this.dataConnection.getType(), this.dataConnection.getUrl()));
            return this.connection;
        }
        catch (HikariPool.PoolInitializationException | SQLException exception) {
            throw new ConnectionException(String.format("connect to %s %s failed", this.dataConnection.getType(), this.dataConnection.getUrl()), exception);
        }
    }

    public void close() {
        this.logger.info(String.format("closing connection to %s...", this.dataConnection.getUrl()));
        try {
            HikariDataSource datasource;
            Connection connection = this.connection;
            if (connection != null && this.closed()) {
                connection.close();
            }
            if ((datasource = this.hikariDataSource) != null) {
                datasource.close();
            }
        }
        catch (SQLException e) {
            throw new PorterException("connection close failed", (Throwable)e);
        }
    }

    public boolean closed() {
        boolean closed;
        try {
            closed = this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new IllegalStateException("check JDBC connection failed", e);
        }
        return closed;
    }

    public DataConnection getDataConnection() {
        return this.dataConnection;
    }

    private HikariDataSource genDataSource(DataConnection dataConnection, String jdbcUrl) {
        Properties props = new Properties();
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("hikari.properties");){
            props.load(resourceAsStream);
        }
        catch (IOException e) {
            this.logger.severe("hikari property file not found");
        }
        HikariConfig hikariConfig = new HikariConfig(props);
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setUsername(dataConnection.getUsername());
        hikariConfig.setPassword(dataConnection.getPassword());
        hikariConfig.setCatalog(dataConnection.getCatalog());
        hikariConfig.setSchema(dataConnection.getSchema());
        return new HikariDataSource(hikariConfig);
    }
}

