/*
 * Decompiled with CFR 0.152.
 */
package de.xab.porter.api.dataconnection;

import de.xab.porter.api.dataconnection.DataConnection;

public final class SrcConnection
extends DataConnection {
    private Properties properties;
    private String sql;

    private SrcConnection() {
    }

    private SrcConnection(Builder builder) {
        super(builder);
        this.sql = builder.sql;
        this.properties = builder.properties == null ? new Properties() : builder.properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getSql() {
        return this.sql;
    }

    public static final class Properties {
        private boolean readTableMeta;
        private boolean split;
        private String splitColumn;
        private int readerNumber;
        private int batchSize;

        private Properties(Builder builder) {
            this.readTableMeta = builder.readTableMeta;
            this.batchSize = builder.batchSize;
            this.split = builder.split;
            this.splitColumn = builder.splitColumn;
            this.readerNumber = builder.readerNumber;
        }

        private Properties() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean isReadTableMeta() {
            return this.readTableMeta;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public String getSplitColumn() {
            return this.splitColumn;
        }

        public int getReaderNumber() {
            return this.readerNumber;
        }

        public boolean isSplit() {
            return this.split;
        }

        public static final class Builder {
            private boolean readTableMeta;
            private boolean split;
            private String splitColumn;
            private int readerNumber;
            private int batchSize;

            private Builder() {
            }

            public Builder readTableMeta(boolean readTableMeta) {
                this.readTableMeta = readTableMeta;
                return this;
            }

            public Builder batchSize(int batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder split(boolean split) {
                this.split = split;
                return this;
            }

            public Builder splitColumn(String splitColumn) {
                this.splitColumn = splitColumn;
                return this;
            }

            public Builder readerNumber(int readerNumber) {
                this.readerNumber = readerNumber;
                return this;
            }

            public Properties build() {
                return new Properties(this);
            }
        }
    }

    public static final class Builder
    extends DataConnection.AbstractBuilder<SrcConnection> {
        private Properties properties;
        private String sql;

        public Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        @Override
        public SrcConnection build() {
            return new SrcConnection(this);
        }
    }
}

