/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.slot;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.Slot;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DataBus {
    private static final LFLog LOG = LFLoggerManager.getLogger(DataBus.class);
    public static AtomicInteger OCCUPY_COUNT = new AtomicInteger(0);
    private static ConcurrentHashMap<Integer, Slot> SLOTS;
    private static ConcurrentLinkedQueue<Integer> QUEUE;
    private static Integer currentIndexMaxValue;

    public static void init() {
        if (MapUtil.isEmpty(SLOTS)) {
            LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
            currentIndexMaxValue = liteflowConfig.getSlotSize();
            SLOTS = new ConcurrentHashMap();
            QUEUE = IntStream.range(0, currentIndexMaxValue).boxed().collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
        }
    }

    public static int offerSlotByClass(List<Class<?>> contextClazzList) {
        List<Object> contextBeanList = contextClazzList.stream().map(ReflectUtil::newInstanceIfPossible).collect(Collectors.toList());
        Slot slot = new Slot(contextBeanList);
        return DataBus.offerIndex(slot);
    }

    public static int offerSlotByBean(List<Object> contextList) {
        Slot slot = new Slot(contextList);
        return DataBus.offerIndex(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static int offerIndex(Slot slot) {
        try {
            Integer slotIndex = QUEUE.poll();
            if (ObjectUtil.isNull((Object)slotIndex)) {
                Class<DataBus> clazz = DataBus.class;
                // MONITORENTER : com.yomahub.liteflow.slot.DataBus.class
                slotIndex = QUEUE.poll();
                if (ObjectUtil.isNull((Object)slotIndex)) {
                    int nextMaxIndex = (int)Math.round((double)currentIndexMaxValue.intValue() * 1.75);
                    QUEUE.addAll(IntStream.range(currentIndexMaxValue, nextMaxIndex).boxed().collect(Collectors.toCollection(ConcurrentLinkedQueue::new)));
                    currentIndexMaxValue = nextMaxIndex;
                    slotIndex = QUEUE.poll();
                }
                // MONITOREXIT : clazz
            }
            if (!ObjectUtil.isNotNull((Object)slotIndex)) return -1;
            SLOTS.put(slotIndex, slot);
            OCCUPY_COUNT.incrementAndGet();
            return slotIndex;
        }
        catch (Exception e) {
            LOG.error("offer slot error", e);
            return -1;
        }
    }

    public static Slot getSlot(int slotIndex) {
        return SLOTS.get(slotIndex);
    }

    public static List<Object> getContextBeanList(int slotIndex) {
        Slot slot = DataBus.getSlot(slotIndex);
        return slot.getContextBeanList();
    }

    public static void releaseSlot(int slotIndex) {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (ObjectUtil.isNotNull((Object)SLOTS.get(slotIndex))) {
            LOG.info("slot[{}] released", (Object)slotIndex);
            SLOTS.remove(slotIndex);
            QUEUE.add(slotIndex);
            OCCUPY_COUNT.decrementAndGet();
        } else {
            LOG.warn("slot[{}] already has been released", (Object)slotIndex);
        }
    }
}

